/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.xmi.util;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;

public abstract class EmfUtil {
    private static final URI DEFAULT_URI = URI.createFileURI("foo.ecore");

    private EmfUtil() {
    }

    public static Object createFromString(EDataType type, String value) {
        try {
            return type.getEPackage().getEFactoryInstance().createFromString(type, value);
        }
        catch (NumberFormatException e) {
            return value;
        }
        catch (IllegalArgumentException e) {
            return value;
        }
    }

    public static boolean isContainmentReference(EStructuralFeature feature) {
        return feature != null && feature instanceof EReference && ((EReference)feature).isContainment();
    }

    public static List<EClass> getAllEClassesFromSameMetamodelAs(EModelElement metamodelElement) {
        return EmfUtil.getAllModelElementsOfType(metamodelElement, EClass.class);
    }

    public static <T extends EObject> List<T> getAllModelElementsOfType(EObject modelElement, Class<T> type) {
        return EmfUtil.getAllModelElementsOfType(modelElement.eResource(), type);
    }

    public static <T extends EObject> List<T> getAllModelElementsOfType(Resource resource, Class<T> type) {
        LinkedList<EObject> results = new LinkedList<EObject>();
        if (resource != null) {
            TreeIterator<EObject> iterator = resource.getAllContents();
            while (iterator.hasNext()) {
                EObject object = (EObject)iterator.next();
                if (!type.isInstance(object)) continue;
                results.add(object);
            }
        }
        return Collections.unmodifiableList(results);
    }

    public static Resource createResource() {
        return EmfUtil.createResource(DEFAULT_URI);
    }

    public static Resource createResource(URI uri) {
        return EmfUtil.createResource(null, uri);
    }

    public static Resource createResource(EObject rootObject) {
        return EmfUtil.createResource(rootObject, DEFAULT_URI);
    }

    public static Resource createResource(EObject rootObject, URI uri) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new EcoreResourceFactoryImpl());
        Resource resource = resourceSet.createResource(uri);
        if (rootObject != null) {
            resource.getContents().add(rootObject);
        }
        return resource;
    }
}

