/*
 * Decompiled with CFR 0.152.
 */
package org.bounce;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.HashMap;
import org.bounce.FormConstraints;

public class FormLayout
implements LayoutManager2 {
    private static final int MINIMUM = 0;
    private static final int PREFERRED = 1;
    private static final int MAXIMUM = 2;
    public static final FormConstraints LEFT = new FormConstraints(0);
    public static final FormConstraints RIGHT = new FormConstraints(2);
    public static final FormConstraints RIGHT_FILL = new FormConstraints(2, true);
    public static final FormConstraints FULL = new FormConstraints(5);
    public static final FormConstraints FULL_FILL = new FormConstraints(5, true);
    private int horizontalGap;
    private int verticalGap;
    private HashMap<Component, FormConstraints> constraints;

    public FormLayout() {
        this(0, 0);
    }

    public FormLayout(int n, int n2) {
        this.horizontalGap = n;
        this.verticalGap = n2;
        this.constraints = new HashMap();
    }

    public int getHgap() {
        return this.horizontalGap;
    }

    public void setHgap(int n) {
        this.horizontalGap = n;
    }

    public int getVgap() {
        return this.verticalGap;
    }

    public void setVgap(int n) {
        this.verticalGap = n;
    }

    public void setConstraints(Component component, Object object) {
        if (object == null || !(object instanceof FormConstraints)) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be of type FormConstraints");
        }
        this.constraints.put(component, new FormConstraints((FormConstraints)object));
    }

    public void removeLayoutComponent(Component component) {
        this.constraints.remove(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            return this.getSize(1, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            return this.getSize(0, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.getComponentCount();
            Dimension dimension = container.getSize();
            int n2 = this.getWidth(0, 1, container);
            int n3 = dimension.width - (insets.left + insets.right);
            int n4 = insets.top;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                FormConstraints formConstraints = this.constraints.get(component);
                int n5 = component.getPreferredSize().height;
                if (formConstraints.getPosition() == 0) {
                    Component component2 = container.getComponent(++i);
                    FormConstraints formConstraints2 = this.constraints.get(component2);
                    if (component.isVisible()) {
                        n5 = component2.getPreferredSize().height > component.getPreferredSize().height ? component2.getPreferredSize().height : component.getPreferredSize().height;
                        if (formConstraints2.getPosition() == 2) {
                            this.align(formConstraints2, new Rectangle(insets.left + n2 + this.horizontalGap, n4, n3 - n2 - this.horizontalGap, n5), component2);
                        } else {
                            --i;
                        }
                    } else {
                        --i;
                    }
                    this.align(formConstraints, new Rectangle(insets.left, n4, n2, n5), component);
                } else if (formConstraints.getPosition() == 2) {
                    this.align(formConstraints, new Rectangle(insets.left + n2 + this.horizontalGap, n4, n3 - n2 - this.horizontalGap, n5), component);
                } else if (formConstraints.getPosition() == 5) {
                    this.align(formConstraints, new Rectangle(insets.left, n4, n3, n5), component);
                }
                n4 += this.verticalGap + n5;
            }
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        this.setConstraints(component, object);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void addLayoutComponent(String string, Component component) {
    }

    private int getHeight(int n, Container container) {
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            n4 = this.getSize((int)n, (Component)component).height;
            FormConstraints formConstraints = this.constraints.get(component);
            if (formConstraints.getPosition() == 0) {
                if (!bl) {
                    n2 += n3;
                    ++n5;
                }
                n3 = n4;
                bl = false;
            } else if (formConstraints.getPosition() == 2) {
                if (!bl) {
                    if (n4 < n3) {
                        n4 = n3;
                    }
                    bl = true;
                }
            } else if (formConstraints.getPosition() == 5 && !bl) {
                n4 += n3;
                bl = true;
            }
            if (!bl) continue;
            n2 += n4;
            ++n5;
        }
        if (!bl) {
            n2 += n4;
            ++n5;
        }
        return n2 + this.verticalGap * (n5 - 1);
    }

    private Dimension getSize(int n, Component component) {
        Dimension dimension = null;
        switch (n) {
            case 0: {
                dimension = component.getMinimumSize();
                break;
            }
            case 1: {
                dimension = component.getPreferredSize();
                break;
            }
            case 2: {
                dimension = component.getMaximumSize();
            }
        }
        return dimension;
    }

    private Dimension getSize(int n, Container container) {
        Dimension dimension = new Dimension(0, 0);
        int n2 = this.getHeight(n, container);
        Insets insets = container.getInsets();
        int n3 = this.getWidth(0, n, container);
        int n4 = this.getWidth(2, n, container);
        int n5 = this.getWidth(5, n, container);
        dimension.width = n5 < n3 + n4 + this.horizontalGap ? n3 + n4 + this.horizontalGap + insets.left + insets.right : n5 + insets.left + insets.right;
        dimension.height = n2 + insets.top + insets.bottom;
        return dimension;
    }

    private int getWidth(int n, int n2, Container container) {
        int n3 = 0;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            FormConstraints formConstraints;
            Component component = container.getComponent(i);
            if (!component.isVisible() || (formConstraints = this.constraints.get(component)).getPosition() != n || formConstraints.isFilled()) continue;
            Dimension dimension = this.getSize(n2, component);
            if (dimension.width <= n3) continue;
            n3 = dimension.width;
        }
        return n3;
    }

    private void align(FormConstraints formConstraints, Rectangle rectangle, Component component) {
        if (!formConstraints.isFilled()) {
            int n;
            if (formConstraints.getHorizontalAlignment() == 4) {
                n = rectangle.x + (rectangle.width - component.getPreferredSize().width) / 2;
                if (n > rectangle.x) {
                    rectangle.x = n;
                }
            } else if (formConstraints.getHorizontalAlignment() == 2 && (n = rectangle.width + rectangle.x - component.getPreferredSize().width) > rectangle.x) {
                rectangle.x = n;
            }
            if (component.getPreferredSize().height != rectangle.height) {
                if (formConstraints.getVerticalAlignment() == 4) {
                    n = rectangle.y + (rectangle.height - component.getPreferredSize().height) / 2;
                    if (n > rectangle.y) {
                        rectangle.y = n;
                    }
                } else if (formConstraints.getVerticalAlignment() == 1 && (n = rectangle.height + rectangle.y - component.getPreferredSize().height) > rectangle.y) {
                    rectangle.y = n;
                }
                rectangle.height = component.getPreferredSize().height;
            }
            rectangle.width = component.getPreferredSize().width;
        }
        component.setBounds(rectangle);
    }
}

