/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.AttributeEvaluator;
import weka.core.Capabilities;
import weka.core.ContingencyTables;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public class SymmetricalUncertAttributeEval
extends ASEvaluation
implements AttributeEvaluator,
OptionHandler {
    static final long serialVersionUID = -8096505776132296416L;
    private Instances m_trainInstances;
    private int m_classIndex;
    private int m_numInstances;
    private int m_numClasses;
    private boolean m_missing_merge;

    public String globalInfo() {
        return "SymmetricalUncertAttributeEval :\n\nEvaluates the worth of an attribute by measuring the symmetrical uncertainty with respect to the class. \n\n SymmU(Class, Attribute) = 2 * (H(Class) - H(Class | Attribute)) / H(Class) + H(Attribute).\n";
    }

    public SymmetricalUncertAttributeEval() {
        this.resetOptions();
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\ttreat missing values as a seperate value.", "M", 0, "-M"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        this.setMissingMerge(!Utils.getFlag('M', options));
    }

    public String missingMergeTipText() {
        return "Distribute counts for missing values. Counts are distributed across other values in proportion to their frequency. Otherwise, missing is treated as a separate value.";
    }

    public void setMissingMerge(boolean b) {
        this.m_missing_merge = b;
    }

    public boolean getMissingMerge() {
        return this.m_missing_merge;
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[1];
        int current = 0;
        if (!this.getMissingMerge()) {
            options[current++] = "-M";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildEvaluator(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_trainInstances = data;
        this.m_classIndex = this.m_trainInstances.classIndex();
        this.m_numInstances = this.m_trainInstances.numInstances();
        Discretize disTransform = new Discretize();
        disTransform.setUseBetterEncoding(true);
        disTransform.setInputFormat(this.m_trainInstances);
        this.m_trainInstances = Filter.useFilter(this.m_trainInstances, disTransform);
        this.m_numClasses = this.m_trainInstances.attribute(this.m_classIndex).numValues();
    }

    protected void resetOptions() {
        this.m_trainInstances = null;
        this.m_missing_merge = true;
    }

    @Override
    public double evaluateAttribute(int attribute) throws Exception {
        int j;
        double sum = 0.0;
        int ni = this.m_trainInstances.attribute(attribute).numValues() + 1;
        int nj = this.m_numClasses + 1;
        double temp = 0.0;
        double[] sumi = new double[ni];
        double[] sumj = new double[nj];
        double[][] counts = new double[ni][nj];
        sumi = new double[ni];
        sumj = new double[nj];
        int i = 0;
        while (i < ni) {
            sumi[i] = 0.0;
            j = 0;
            while (j < nj) {
                sumj[j] = 0.0;
                counts[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numInstances) {
            Instance inst = this.m_trainInstances.instance(i);
            int ii = inst.isMissing(attribute) ? ni - 1 : (int)inst.value(attribute);
            int jj = inst.isMissing(this.m_classIndex) ? nj - 1 : (int)inst.value(this.m_classIndex);
            double[] dArray = counts[ii];
            int n = jj;
            dArray[n] = dArray[n] + 1.0;
            ++i;
        }
        i = 0;
        while (i < ni) {
            sumi[i] = 0.0;
            j = 0;
            while (j < nj) {
                int n = i;
                sumi[n] = sumi[n] + counts[i][j];
                sum += counts[i][j];
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < nj) {
            sumj[j] = 0.0;
            i = 0;
            while (i < ni) {
                int n = j;
                sumj[n] = sumj[n] + counts[i][j];
                ++i;
            }
            ++j;
        }
        if (this.m_missing_merge && sumi[ni - 1] < (double)this.m_numInstances && sumj[nj - 1] < (double)this.m_numInstances) {
            double[] i_copy = new double[sumi.length];
            double[] j_copy = new double[sumj.length];
            double[][] counts_copy = new double[sumi.length][sumj.length];
            i = 0;
            while (i < ni) {
                System.arraycopy(counts[i], 0, counts_copy[i], 0, sumj.length);
                ++i;
            }
            System.arraycopy(sumi, 0, i_copy, 0, sumi.length);
            System.arraycopy(sumj, 0, j_copy, 0, sumj.length);
            double total_missing = sumi[ni - 1] + sumj[nj - 1] - counts[ni - 1][nj - 1];
            if (sumi[ni - 1] > 0.0) {
                j = 0;
                while (j < nj - 1) {
                    if (counts[ni - 1][j] > 0.0) {
                        i = 0;
                        while (i < ni - 1) {
                            temp = i_copy[i] / (sum - i_copy[ni - 1]) * counts[ni - 1][j];
                            double[] dArray = counts[i];
                            int n = j;
                            dArray[n] = dArray[n] + temp;
                            int n2 = i++;
                            sumi[n2] = sumi[n2] + temp;
                        }
                        counts[ni - 1][j] = 0.0;
                    }
                    ++j;
                }
            }
            sumi[ni - 1] = 0.0;
            if (sumj[nj - 1] > 0.0) {
                i = 0;
                while (i < ni - 1) {
                    if (counts[i][nj - 1] > 0.0) {
                        j = 0;
                        while (j < nj - 1) {
                            temp = j_copy[j] / (sum - j_copy[nj - 1]) * counts[i][nj - 1];
                            double[] dArray = counts[i];
                            int n = j;
                            dArray[n] = dArray[n] + temp;
                            int n3 = j++;
                            sumj[n3] = sumj[n3] + temp;
                        }
                        counts[i][nj - 1] = 0.0;
                    }
                    ++i;
                }
            }
            sumj[nj - 1] = 0.0;
            if (counts[ni - 1][nj - 1] > 0.0 && total_missing != sum) {
                i = 0;
                while (i < ni - 1) {
                    j = 0;
                    while (j < nj - 1) {
                        temp = counts_copy[i][j] / (sum - total_missing) * counts_copy[ni - 1][nj - 1];
                        double[] dArray = counts[i];
                        int n = j;
                        dArray[n] = dArray[n] + temp;
                        int n4 = i;
                        sumi[n4] = sumi[n4] + temp;
                        int n5 = j++;
                        sumj[n5] = sumj[n5] + temp;
                    }
                    ++i;
                }
                counts[ni - 1][nj - 1] = 0.0;
            }
        }
        return ContingencyTables.symmetricalUncertainty(counts);
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_trainInstances == null) {
            text.append("\tSymmetrical Uncertainty evaluator has not been built");
        } else {
            text.append("\tSymmetrical Uncertainty Ranking Filter");
            if (!this.m_missing_merge) {
                text.append("\n\tMissing values treated as seperate");
            }
        }
        text.append("\n");
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10172 $");
    }

    public static void main(String[] argv) {
        SymmetricalUncertAttributeEval.runEvaluator(new SymmetricalUncertAttributeEval(), argv);
    }
}

