/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.epl.combinations;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.eclipse.epsilon.epl.combinations.CombinationGenerator;
import org.eclipse.epsilon.epl.combinations.CompositeCombinationValidator;

public class CompositeCombinationGenerator<T>
implements CombinationGenerator<List<T>> {
    protected ArrayList<CombinationGenerator<T>> generators = new ArrayList();
    protected int currentGeneratorIndex = 0;
    protected Stack<List<T>> currentStack = new Stack();
    protected CompositeCombinationValidator<T> validator = null;
    protected List<List<T>> NEXT = new ArrayList<List<T>>();
    protected List<List<T>> UNKNOWN = new LinkedList<List<T>>();
    protected List<List<T>> lookahead = this.UNKNOWN;

    public static void main(String[] args) throws Exception {
        CompositeCombinationGenerator ccg = new CompositeCombinationGenerator();
    }

    public static List<String> createList(String ... strings) {
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            list.add(str);
            ++n2;
        }
        return list;
    }

    public CompositeCombinationValidator<T> getValidator() {
        return this.validator;
    }

    public void setValidator(CompositeCombinationValidator<T> validator) {
        this.validator = validator;
    }

    public void addCombinationGenerator(CombinationGenerator<T> g) {
        this.generators.add(g);
        this.reset();
    }

    public boolean removeCombinationGenerator(CombinationGenerator<T> g) {
        boolean removed = this.generators.remove(g);
        this.reset();
        return removed;
    }

    @Override
    public boolean hasMore() throws Exception {
        if (this.lookahead == this.UNKNOWN) {
            this.lookahead = this.getNextImpl();
            while (this.lookahead == this.NEXT) {
                this.lookahead = this.getNextImpl();
            }
        }
        return this.lookahead != null;
    }

    @Override
    public List<List<T>> getNext() throws Exception {
        if (this.lookahead != this.UNKNOWN) {
            List<List<T>> result = this.lookahead;
            this.lookahead = this.UNKNOWN;
            return result;
        }
        List<List<T>> next = this.getNextImpl();
        while (next == this.NEXT) {
            next = this.getNextImpl();
        }
        return next;
    }

    protected List<List<T>> getNextImpl() throws Exception {
        while (!this.getCurrentGenerator().hasMore()) {
            if (this.isFirstGenerator()) {
                return null;
            }
            this.currentStack.pop();
            this.getCurrentGenerator().reset();
            this.setCurrentGenerator(this.getPreviousGenerator());
        }
        if (!this.currentStack.isEmpty()) {
            this.currentStack.pop();
        }
        this.currentStack.push(this.getCurrentGenerator().getNext());
        boolean validCombination = this.isValidCombination();
        if (validCombination) {
            this.getCurrentGenerator().producedValidCombination();
        }
        while (!this.isLastGenerator() && validCombination) {
            this.setCurrentGenerator(this.getNextGenerator());
            this.currentStack.push(this.getCurrentGenerator().getNext());
            validCombination = this.isValidCombination();
            if (!validCombination) continue;
            this.getCurrentGenerator().producedValidCombination();
        }
        if (validCombination) {
            return this.currentStack;
        }
        return this.NEXT;
    }

    @Override
    public void reset() {
        for (CombinationGenerator<T> g : this.generators) {
            g.reset();
        }
        if (!this.generators.isEmpty()) {
            this.currentGeneratorIndex = 0;
        }
    }

    protected boolean isValidCombination() throws Exception {
        for (List list : this.currentStack) {
            if (list != null) continue;
            return false;
        }
        if (this.validator == null) {
            return true;
        }
        return this.validator.isValid(this.currentStack);
    }

    protected CombinationGenerator<T> getPreviousGenerator() {
        if (this.currentGeneratorIndex == 0) {
            return null;
        }
        return this.generators.get(this.currentGeneratorIndex - 1);
    }

    protected CombinationGenerator<T> getNextGenerator() {
        if (this.currentGeneratorIndex == this.generators.size() - 1) {
            return null;
        }
        return this.generators.get(this.currentGeneratorIndex + 1);
    }

    protected CombinationGenerator<T> getCurrentGenerator() {
        return this.generators.get(this.currentGeneratorIndex);
    }

    protected void setCurrentGenerator(CombinationGenerator<T> g) {
        this.currentGeneratorIndex = this.generators.indexOf(g);
    }

    protected boolean isFirstGenerator() {
        return this.getPreviousGenerator() == null;
    }

    protected boolean isLastGenerator() {
        return this.getNextGenerator() == null;
    }

    @Override
    public void producedValidCombination() {
    }
}

