/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl;

import java.util.ListIterator;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.userinput.IUserInput;
import org.eclipse.epsilon.evl.EvlFixInstance;
import org.eclipse.epsilon.evl.EvlUnsatisfiedConstraint;
import org.eclipse.epsilon.evl.IEvlFixer;
import org.eclipse.epsilon.evl.IEvlModule;
import org.eclipse.epsilon.evl.execute.context.IEvlContext;

public class CommandLineFixer
implements IEvlFixer {
    protected boolean fix = false;

    @Override
    public void fix(IEvlModule module) throws EolRuntimeException {
        IEvlContext context = module.getContext();
        IUserInput userInput = context.getUserInput();
        ListIterator<EvlUnsatisfiedConstraint> li = context.getUnsatisfiedConstraints().listIterator();
        while (li.hasNext()) {
            EvlFixInstance fixInstance;
            boolean fixIt;
            EvlUnsatisfiedConstraint unsatisfiedConstraint = li.next();
            context.getOutputStream().println(unsatisfiedConstraint.getMessage());
            boolean bl = fixIt = this.fix && unsatisfiedConstraint.getFixes().size() > 0 && userInput.confirm("Fix error?", true);
            if (!fixIt || (fixInstance = (EvlFixInstance)userInput.choose(unsatisfiedConstraint.getMessage(), unsatisfiedConstraint.getFixes(), null)) == null) continue;
            fixInstance.perform();
        }
    }

    public boolean isFix() {
        return this.fix;
    }

    public void setFix(boolean fix) {
        this.fix = fix;
    }
}

