/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.parse;

import java.io.File;
import java.io.FileInputStream;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.eclipse.epsilon.common.parse.StaticFieldNameResolver;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.common.util.FileUtil;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.parse.AstExplorer;
import org.eclipse.epsilon.eol.parse.EolLexer;
import org.eclipse.epsilon.eol.parse.EolParser;

public class EolParserWorkbench {
    static String basePath = FileUtil.getPath("test.eol", EolParserWorkbench.class);
    StaticFieldNameResolver r;

    public static void main(String[] args) throws Exception {
        new EolParserWorkbench().work();
    }

    public void workPathName() throws Exception {
        ANTLRInputStream input = new ANTLRInputStream(new FileInputStream(basePath));
        EolLexer lexer = new EolLexer(input);
        CommonTokenStream stream = new CommonTokenStream(lexer);
        EolParser parser = new EolParser(stream);
        System.err.println(((CommonTree)parser.eolModule().getTree()).toStringTree());
    }

    public void work() throws Exception {
        EolModule module = new EolModule();
        module.parse(new File(basePath));
        if (module.getParseProblems().size() > 0) {
            for (ParseProblem pp : module.getParseProblems()) {
                System.err.println(pp);
            }
        }
        new AstExplorer(module.getAst(), EolParser.class);
    }

    public void print(Tree tree, int indent) {
        System.err.println(String.valueOf(this.getIndent(indent)) + tree.getText());
        int i = 0;
        while (i < tree.getChildCount()) {
            this.print(tree.getChild(i), indent + 1);
            ++i;
        }
    }

    public String getIndent(int indent) {
        String str = "";
        int i = 0;
        while (i < indent) {
            str = String.valueOf(str) + "--";
            ++i;
        }
        return str;
    }
}

