/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.formatter.language;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.egl.util.StringUtil;

public abstract class LanguageFormatter
implements Formatter {
    private final Pattern increasePattern;
    private final Pattern decreasePattern;

    protected LanguageFormatter(String increasePattern, String decreasePattern) {
        this.increasePattern = Pattern.compile(increasePattern);
        this.decreasePattern = Pattern.compile(decreasePattern);
    }

    protected LanguageFormatter(Pattern increasePattern, Pattern decreasePattern) {
        this.increasePattern = increasePattern;
        this.decreasePattern = decreasePattern;
    }

    private String clean(String text) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = Pattern.compile("^", 8).split(text);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.length() > 0) {
                int position = 0;
                char current = line.charAt(0);
                while (position < line.length() - 1 && (current == ' ' || current == '\t')) {
                    current = line.charAt(++position);
                }
                sb.append(line.substring(position));
            }
            ++n2;
        }
        return sb.toString();
    }

    @Override
    public String format(String text) {
        String cleaned = this.clean(text);
        Matcher increaseMatcher = this.increasePattern.matcher(cleaned);
        Matcher decreaseMatcher = this.decreasePattern.matcher(cleaned);
        LinkedList<Integer> increaseIndentationAt = new LinkedList<Integer>();
        LinkedList<Integer> decreaseIndentationAt = new LinkedList<Integer>();
        while (increaseMatcher.find()) {
            increaseIndentationAt.offer(increaseMatcher.end());
        }
        while (decreaseMatcher.find()) {
            decreaseIndentationAt.offer(decreaseMatcher.start());
        }
        StringBuilder sb = new StringBuilder();
        int position = 0;
        int indent = 0;
        String[] stringArray = Pattern.compile("^", 8).split(cleaned);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            position += line.length();
            sb.append(StringUtil.tabs(indent));
            while (!increaseIndentationAt.isEmpty() && position > (Integer)increaseIndentationAt.peek()) {
                ++indent;
                increaseIndentationAt.remove();
            }
            while (!decreaseIndentationAt.isEmpty() && position > (Integer)decreaseIndentationAt.peek()) {
                if (position - line.length() == (Integer)decreaseIndentationAt.peek() && sb.charAt(sb.length() - 1) == '\t') {
                    sb.deleteCharAt(sb.length() - 1);
                }
                --indent;
                decreaseIndentationAt.remove();
            }
            sb.append(line);
            ++n2;
        }
        return sb.toString();
    }
}

