/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute;

import java.util.Arrays;
import java.util.HashSet;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.PointExecutor;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.ISearchableModel;
import org.eclipse.epsilon.eol.models.ModelRepository;
import org.eclipse.epsilon.eol.types.EolModelElementType;

public class OptimisedPointExecutor
extends PointExecutor {
    protected HashSet<String> optimisableOperations = new HashSet<String>(Arrays.asList("select", "selectOne", "exists", "forAll"));
    protected HashSet<String> allOperations = new HashSet<String>(Arrays.asList("all", "allInstances"));
    protected boolean arrow;

    public OptimisedPointExecutor(boolean arrow) {
        this.arrow = arrow;
    }

    @Override
    protected boolean isArrow() {
        return this.arrow;
    }

    protected boolean containsSearchableModels(ModelRepository modelRepository) {
        for (IModel model : modelRepository.getModels()) {
            if (!(model instanceof ISearchableModel)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object execute(AST ast, IEolContext context) throws EolRuntimeException {
        block12: {
            if (!this.containsSearchableModels(context.getModelRepository())) {
                return super.execute(ast, context);
            }
            AST targetAst = ast.getChild(0);
            AST featureCallAst = ast.getChild(1);
            String operationName = featureCallAst.getText();
            if (targetAst.getType() == 9 && this.optimisableOperations.contains(operationName)) {
                boolean targetTargetLooksLikeTypeName;
                AST targetTargetAst = targetAst.getChild(0);
                AST targetFeatureCallAst = targetAst.getChild(1);
                boolean bl = targetTargetLooksLikeTypeName = targetTargetAst.getType() == 19 || targetTargetAst.getType() == 62 && targetTargetAst.getChildren().isEmpty();
                if (this.allOperations.contains(targetFeatureCallAst.getText()) && targetTargetLooksLikeTypeName) {
                    try {
                        boolean one;
                        EolModelElementType type = EolModelElementType.forName(targetTargetAst.getText(), context);
                        boolean bl2 = one = !operationName.equals("select");
                        if (type == null || !(type.getModel() instanceof ISearchableModel)) break block12;
                        ISearchableModel searchableModel = (ISearchableModel)((Object)type.getModel());
                        String iteratorName = featureCallAst.getFirstChild().getFirstChild().getFirstChild().getText();
                        Variable iterator = new Variable(iteratorName, null, type);
                        AST parametersAst = featureCallAst.getChild(1);
                        if (operationName.equals("forAll")) {
                            CommonToken notToken = new CommonToken(58);
                            notToken.setText("not");
                            AST notAst = new AST((Token)notToken, parametersAst);
                            notAst.addChild(parametersAst);
                            parametersAst = notAst;
                        }
                        if (one) {
                            Object result = searchableModel.findOne(iterator, parametersAst, context);
                            if (operationName.equals("exists")) {
                                if (result != null) {
                                    return true;
                                }
                                return false;
                            }
                            if (operationName.equals("selectOne")) {
                                return result;
                            }
                            if (operationName.equals("forAll")) {
                                if (result == null) {
                                    return true;
                                }
                                return false;
                            }
                            break block12;
                        }
                        return searchableModel.find(iterator, parametersAst, context);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        return super.execute(ast, context);
    }
}

