/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.types.EolNativeType;

public class ReflectionUtil {
    public static boolean hasMethods(Object obj, String methodName) {
        if (obj == null) {
            return false;
        }
        Method[] methodArray = obj.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (ReflectionUtil.getMethodName(method).equals(methodName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Set<String> getMethodNames(Object obj, boolean includeInheritedMethods) {
        HashSet<String> methodNames = new HashSet<String>();
        if (obj == null) {
            return methodNames;
        }
        Method[] methods = null;
        methods = includeInheritedMethods ? obj.getClass().getMethods() : obj.getClass().getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            methodNames.add(ReflectionUtil.getMethodName(methods[i]));
            ++i;
        }
        return methodNames;
    }

    protected static String getMethodName(Method method) {
        String methodName = method.getName();
        if (methodName.startsWith("_")) {
            methodName = methodName.substring(1);
        }
        return methodName;
    }

    public static Method getMethodFor(Object obj, String methodName, Object[] parameters, boolean includeInheritedMethods, boolean allowContravariantConversionForParameters) {
        if (obj == null) {
            return null;
        }
        Method instanceMethod = ReflectionUtil.getInstanceMethodFor(obj, methodName, parameters, includeInheritedMethods, allowContravariantConversionForParameters);
        if (instanceMethod != null) {
            return instanceMethod;
        }
        Method staticMethod = ReflectionUtil.getStaticMethodFor(obj, methodName, parameters, allowContravariantConversionForParameters);
        if (staticMethod != null) {
            return staticMethod;
        }
        return null;
    }

    private static Method getInstanceMethodFor(Object obj, String methodName, Object[] parameters, boolean includeInheritedMethods, boolean allowContravariantConversionForParameters) {
        Method[] methods = null;
        methods = includeInheritedMethods ? obj.getClass().getMethods() : obj.getClass().getDeclaredMethods();
        return ReflectionUtil.searchMethodsFor(methods, methodName, parameters, allowContravariantConversionForParameters);
    }

    private static Method getStaticMethodFor(Object obj, String methodName, Object[] parameters, boolean allowContravariantConversionForParameters) {
        Method staticMethod = null;
        Class javaClass = null;
        if (obj instanceof EolNativeType) {
            javaClass = ((EolNativeType)obj).getJavaClass();
        }
        if (obj instanceof Class) {
            javaClass = (Class)obj;
        }
        if (javaClass != null) {
            staticMethod = ReflectionUtil.searchMethodsFor(javaClass.getMethods(), methodName, parameters, allowContravariantConversionForParameters);
        }
        return staticMethod;
    }

    private static Method searchMethodsFor(Method[] methods, String methodName, Object[] parameters, boolean allowContravariantConversionForParameters) {
        int stage = 0;
        while (stage < 2) {
            int i = 0;
            while (i < methods.length) {
                boolean namesMatch = false;
                namesMatch = ReflectionUtil.getMethodName(methods[i]).equalsIgnoreCase(methodName);
                if (namesMatch) {
                    boolean parametersMatch;
                    Method method = methods[i];
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    boolean bl = parametersMatch = parameterTypes.length == parameters.length;
                    if (parametersMatch) {
                        int j = 0;
                        while (j < parameterTypes.length && parametersMatch) {
                            Class<?> parameterType = parameterTypes[j];
                            Object parameter = parameters[j];
                            parametersMatch = allowContravariantConversionForParameters ? parametersMatch && (stage == 0 ? parameterType.isInstance(parameter) : ReflectionUtil.isInstance(parameterType, parameter)) : parametersMatch && parameterType.equals(parameter.getClass());
                            ++j;
                        }
                        if (parametersMatch) {
                            return method;
                        }
                    }
                }
                ++i;
            }
            ++stage;
        }
        return null;
    }

    public static Object executeMethod(Object obj, Method method, Object[] parameters, AST ast) throws EolRuntimeException {
        try {
            return ReflectionUtil.executeMethod(method, obj, parameters);
        }
        catch (Throwable t) {
            throw new EolInternalException(t, ast);
        }
    }

    public static Object executeMethod(Object obj, String methodName, Object[] parameters) throws Throwable {
        Method method = ReflectionUtil.getMethodFor(obj, methodName, parameters, true, true);
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(obj, parameters);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static Object executeMethod(Method method, Object obj, Object[] parameters) throws Throwable {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(obj, parameters);
        }
        catch (InvocationTargetException iex) {
            throw iex.getCause();
        }
    }

    public static String methodToString(Method method) {
        String str = ReflectionUtil.getMethodName(method);
        str = String.valueOf(str) + "(";
        int i = 0;
        while (i < method.getParameterTypes().length) {
            Class<?> parameterType = method.getParameterTypes()[i];
            str = String.valueOf(str) + parameterType.getName();
            if (i < method.getParameterTypes().length - 1) {
                str = String.valueOf(str) + " ,";
            }
            ++i;
        }
        str = String.valueOf(str) + ")";
        return str;
    }

    public static Object getFieldValue(Object object, String fieldName) {
        if (object == null) {
            return null;
        }
        Field field = ReflectionUtil.getField(object.getClass(), fieldName);
        if (field == null) {
            return null;
        }
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName().equals(fieldName)) {
                return fields[i];
            }
            ++i;
        }
        if (clazz.getSuperclass() != Object.class) {
            return ReflectionUtil.getField(clazz.getSuperclass(), fieldName);
        }
        return null;
    }

    public static boolean isInstance(Class<?> clazz, Object instance) {
        if (instance == null) {
            return true;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class.isInstance(instance);
        }
        if (clazz == Float.TYPE) {
            return Float.class.isInstance(instance);
        }
        if (clazz == Double.TYPE) {
            return Double.class.isInstance(instance);
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class.isInstance(instance);
        }
        if (clazz == Long.TYPE) {
            return Long.class.isInstance(instance);
        }
        if (clazz == Character.TYPE) {
            return Character.class.isInstance(instance);
        }
        return clazz.isInstance(instance);
    }

    public static List<Field> getAllInheritedInstanceFields(Class<?> klazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Field[] fieldArray = klazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (!Modifier.isStatic(f.getModifiers())) {
                fields.add(f);
            }
            ++n2;
        }
        if (klazz.getSuperclass() != null) {
            fields.addAll(ReflectionUtil.getAllInheritedInstanceFields(klazz.getSuperclass()));
        }
        return fields;
    }
}

