/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.workflow.tasks;

import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.eclipse.epsilon.egl.EglFileGeneratingTemplateFactory;
import org.eclipse.epsilon.egl.EglTemplateFactory;
import org.eclipse.epsilon.egl.EglTemplateFactoryModuleAdapter;
import org.eclipse.epsilon.egl.EgxModule;
import org.eclipse.epsilon.egl.engine.traceability.fine.EglFineGrainedTraceContextAdaptor;
import org.eclipse.epsilon.egl.engine.traceability.fine.trace.ModelLocation;
import org.eclipse.epsilon.egl.engine.traceability.fine.trace.Region;
import org.eclipse.epsilon.egl.engine.traceability.fine.trace.TextLocation;
import org.eclipse.epsilon.egl.engine.traceability.fine.trace.Trace;
import org.eclipse.epsilon.egl.engine.traceability.fine.trace.TraceLink;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.eol.IEolExecutableModule;
import org.eclipse.epsilon.workflow.tasks.ExportableModuleTask;
import org.eclipse.epsilon.workflow.tasks.nestedelements.EglDefaultFormatterNestedElement;

public class EglTask
extends ExportableModuleTask {
    protected File target;
    protected Class<? extends EglTemplateFactory> templateFactoryType = EglFileGeneratingTemplateFactory.class;
    protected List<EglDefaultFormatterNestedElement> defaultFormatterNestedElements = new LinkedList<EglDefaultFormatterNestedElement>();
    protected Trace trace;

    @Override
    protected IEolExecutableModule createModule() throws InstantiationException, IllegalAccessException {
        EglTemplateFactory templateFactory = this.templateFactoryType.newInstance();
        templateFactory.setDefaultFormatters(this.instantiateDefaultFormatters());
        IEolExecutableModule module = this.src.getName().endsWith("egx") ? new EgxModule(templateFactory) : new EglTemplateFactoryModuleAdapter(templateFactory);
        if (this.shouldExportAsModel()) {
            this.trace = new EglFineGrainedTraceContextAdaptor().adapt((IEglContext)module.getContext());
        }
        return module;
    }

    private List<Formatter> instantiateDefaultFormatters() throws InstantiationException, IllegalAccessException {
        LinkedList<Formatter> defaultFormatters = new LinkedList<Formatter>();
        for (EglDefaultFormatterNestedElement defaultFormatterNestedElement : this.defaultFormatterNestedElements) {
            defaultFormatters.add(defaultFormatterNestedElement.getImplementation().newInstance());
        }
        return defaultFormatters;
    }

    @Override
    protected void examine() throws Exception {
        super.examine();
        if (this.target != null) {
            FileWriter fw = new FileWriter(this.target);
            fw.write(String.valueOf(this.result));
            fw.flush();
            fw.close();
        }
    }

    @Override
    protected void initialize() throws Exception {
    }

    public File getTarget() {
        return this.target;
    }

    public void setTarget(File output) {
        this.target = output;
    }

    public Class<? extends EglTemplateFactory> getTemplateFactoryType() {
        return this.templateFactoryType;
    }

    public void setTemplateFactoryType(Class<? extends EglTemplateFactory> templateFactoryType) {
        if (!EglTemplateFactory.class.isAssignableFrom(templateFactoryType)) {
            throw new BuildException("The templateFactoryType parameter must be class that subtypes org.eclipse.epsilon.egl.EglTemplateFactory.");
        }
        this.templateFactoryType = templateFactoryType;
    }

    public EglDefaultFormatterNestedElement createDefaultFormatter() {
        EglDefaultFormatterNestedElement nestedElement = new EglDefaultFormatterNestedElement();
        this.defaultFormatterNestedElements.add(nestedElement);
        return nestedElement;
    }

    @Override
    protected Collection<? extends Class<?>> getClassesForExportedModel() {
        return Arrays.asList(Trace.class, TraceLink.class, TextLocation.class, ModelLocation.class, Region.class);
    }

    @Override
    protected Collection<? extends Object> getObjectsForExportedModel() {
        return this.trace.getAllContents();
    }
}

