/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl.type;

import java.util.Arrays;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.impl.XSDSimpleTypeDefinitionImpl;
import org.eclipse.xsd.util.XSDUtil;

public class XSDAnySimpleType {
    public void assess(XSDSimpleTypeDefinitionImpl.AssessmentImpl assessment) {
        assessment.xsdAnySimpleType = this;
        Object value = this.getValue(assessment.normalizedLiteral);
        if (value != null) {
            assessment.value = value;
        } else {
            assessment.reportDatatypeDiagnostic();
        }
    }

    public Object getValue(String normalizedLiteral) {
        return normalizedLiteral;
    }

    public String getCanonicalLiteral(Object value) {
        return value == null ? null : value.toString();
    }

    public int compareValues(Object value1, Object value2) {
        throw new RuntimeException(XSDPlugin.INSTANCE.getString("_EXC_CompareNotSupported"));
    }

    public static class ByteSequence
    implements XSDUtil.ByteSequence {
        protected final XSDAnySimpleType xsdAnySimpleType;
        protected final byte[] bytes;
        protected String canonical;

        public ByteSequence(XSDAnySimpleType xsdAnySimpleType, byte[] bytes) {
            this.xsdAnySimpleType = xsdAnySimpleType;
            this.bytes = bytes;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public boolean equals(Object that) {
            if (that == this) {
                return true;
            }
            if (that instanceof ByteSequence) {
                return Arrays.equals(this.bytes, ((ByteSequence)that).bytes);
            }
            return false;
        }

        public int hashCode() {
            int hashCode = 1;
            int i = 0;
            while (i < this.bytes.length) {
                byte theByte = this.bytes[i];
                hashCode = 31 * hashCode + theByte;
                ++i;
            }
            return hashCode;
        }

        public String toString() {
            if (this.canonical == null) {
                this.canonical = DataValue.Base64.encode(this.bytes);
            }
            return this.canonical;
        }
    }

    public static class HexSequence
    extends ByteSequence {
        public HexSequence(XSDAnySimpleType xsdAnySimpleType, byte[] bytes) {
            super(xsdAnySimpleType, bytes);
        }

        public String toString() {
            if (this.canonical == null) {
                this.canonical = DataValue.HexBin.encode(this.bytes);
            }
            return this.canonical;
        }
    }
}

