/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.List;
import weka.associations.AssociationRule;
import weka.core.OptionHandler;
import weka.core.Utils;

public class AssociationRules
implements Serializable {
    private static final long serialVersionUID = 8889198755948056749L;
    protected String m_producer = "Unknown";
    protected List<AssociationRule> m_rules;

    public AssociationRules(List<AssociationRule> rules, String producer) {
        this.m_rules = rules;
        this.m_producer = producer;
    }

    public AssociationRules(List<AssociationRule> rules, Object producer) {
        String producerString = producer.getClass().getName();
        if (producerString.startsWith("weka.associations.")) {
            producerString = producerString.substring("weka.associations.".length());
        }
        if (producer instanceof OptionHandler) {
            String[] o = ((OptionHandler)producer).getOptions();
            producerString = String.valueOf(producerString) + " " + Utils.joinOptions(o);
        }
        this.m_rules = rules;
        this.m_producer = producerString;
    }

    public AssociationRules(List<AssociationRule> rules) {
        this(rules, "Unknown");
    }

    public void setRules(List<AssociationRule> rules) {
        this.m_rules = rules;
    }

    public List<AssociationRule> getRules() {
        return this.m_rules;
    }

    public int getNumRules() {
        return this.m_rules.size();
    }

    public void setProducer(String producer) {
        this.m_producer = producer;
    }

    public String getProducer() {
        return this.m_producer;
    }
}

