/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.global;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.search.global.GlobalScoreSearchAlgorithm;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class GeneticSearch
extends GlobalScoreSearchAlgorithm {
    static final long serialVersionUID = 4236165533882462203L;
    int m_nRuns = 10;
    int m_nPopulationSize = 10;
    int m_nDescendantPopulationSize = 100;
    boolean m_bUseCrossOver = true;
    boolean m_bUseMutation = true;
    boolean m_bUseTournamentSelection = false;
    int m_nSeed = 1;
    Random m_random = null;
    static boolean[] g_bIsSquare;

    /*
     * Unable to fully structure code
     */
    @Override
    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
        if (this.getDescendantPopulationSize() < this.getPopulationSize()) {
            throw new Exception("Descendant PopulationSize should be at least Population Size");
        }
        if (!this.getUseCrossOver() && !this.getUseMutation()) {
            throw new Exception("At least one of mutation or cross-over should be used");
        }
        this.m_random = new Random(this.m_nSeed);
        fBestScore = this.calcScore(bayesNet);
        bestBayesNet = new BayesNet();
        bestBayesNet.m_Instances = instances;
        bestBayesNet.initStructure();
        this.copyParentSets(bestBayesNet, bayesNet);
        population = new BayesNetRepresentation[this.getPopulationSize()];
        i = 0;
        while (i < this.getPopulationSize()) {
            population[i] = new BayesNetRepresentation(instances.numAttributes());
            population[i].randomInit();
            if (population[i].getScore() > fBestScore) {
                this.copyParentSets(bestBayesNet, bayesNet);
                fBestScore = population[i].getScore();
            }
            ++i;
        }
        iRun = 0;
        while (iRun < this.m_nRuns) {
            descendantPopulation = new BayesNetRepresentation[this.getDescendantPopulationSize()];
            i = 0;
            while (i < this.getDescendantPopulationSize()) {
                descendantPopulation[i] = population[this.m_random.nextInt(this.getPopulationSize())].copy();
                if (this.getUseMutation()) {
                    if (this.getUseCrossOver() && this.m_random.nextBoolean()) {
                        descendantPopulation[i].crossOver(population[this.m_random.nextInt(this.getPopulationSize())]);
                    } else {
                        descendantPopulation[i].mutate();
                    }
                } else {
                    descendantPopulation[i].crossOver(population[this.m_random.nextInt(this.getPopulationSize())]);
                }
                if (descendantPopulation[i].getScore() > fBestScore) {
                    this.copyParentSets(bestBayesNet, bayesNet);
                    fBestScore = descendantPopulation[i].getScore();
                }
                ++i;
            }
            bSelected = new boolean[this.getDescendantPopulationSize()];
            i = 0;
            while (i < this.getPopulationSize()) {
                block17: {
                    iSelected = 0;
                    if (!this.m_bUseTournamentSelection) ** GOTO lbl56
                    iSelected = this.m_random.nextInt(this.getDescendantPopulationSize());
                    while (bSelected[iSelected]) {
                        iSelected = (iSelected + 1) % this.getDescendantPopulationSize();
                    }
                    iSelected2 = this.m_random.nextInt(this.getDescendantPopulationSize());
                    while (bSelected[iSelected2]) {
                        iSelected2 = (iSelected2 + 1) % this.getDescendantPopulationSize();
                    }
                    if (!(descendantPopulation[iSelected2].getScore() > descendantPopulation[iSelected].getScore())) break block17;
                    iSelected = iSelected2;
                    break block17;
lbl-1000:
                    // 1 sources

                    {
                        ++iSelected;
lbl56:
                        // 2 sources

                        ** while (bSelected[iSelected])
                    }
lbl57:
                    // 1 sources

                    fScore = descendantPopulation[iSelected].getScore();
                    j = 0;
                    while (j < this.getDescendantPopulationSize()) {
                        if (!bSelected[j] && descendantPopulation[j].getScore() > fScore) {
                            fScore = descendantPopulation[j].getScore();
                            iSelected = j;
                        }
                        ++j;
                    }
                }
                population[i] = descendantPopulation[iSelected];
                bSelected[iSelected] = true;
                ++i;
            }
            ++iRun;
        }
        this.copyParentSets(bayesNet, bestBayesNet);
        bestBayesNet = null;
    }

    void copyParentSets(BayesNet dest, BayesNet source) {
        int nNodes = source.getNrOfNodes();
        int iNode = 0;
        while (iNode < nNodes) {
            dest.getParentSet(iNode).copy(source.getParentSet(iNode));
            ++iNode;
        }
    }

    public int getRuns() {
        return this.m_nRuns;
    }

    public void setRuns(int nRuns) {
        this.m_nRuns = nRuns;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(7);
        newVector.addElement(new Option("\tPopulation size", "L", 1, "-L <integer>"));
        newVector.addElement(new Option("\tDescendant population size", "A", 1, "-A <integer>"));
        newVector.addElement(new Option("\tNumber of runs", "U", 1, "-U <integer>"));
        newVector.addElement(new Option("\tUse mutation.\n\t(default true)", "M", 0, "-M"));
        newVector.addElement(new Option("\tUse cross-over.\n\t(default true)", "C", 0, "-C"));
        newVector.addElement(new Option("\tUse tournament selection (true) or maximum subpopulatin (false).\n\t(default false)", "O", 0, "-O"));
        newVector.addElement(new Option("\tRandom number seed", "R", 1, "-R <seed>"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String sSeed;
        String sRuns;
        String sDescendantPopulationSize;
        String sPopulationSize = Utils.getOption('L', options);
        if (sPopulationSize.length() != 0) {
            this.setPopulationSize(Integer.parseInt(sPopulationSize));
        }
        if ((sDescendantPopulationSize = Utils.getOption('A', options)).length() != 0) {
            this.setDescendantPopulationSize(Integer.parseInt(sDescendantPopulationSize));
        }
        if ((sRuns = Utils.getOption('U', options)).length() != 0) {
            this.setRuns(Integer.parseInt(sRuns));
        }
        if ((sSeed = Utils.getOption('R', options)).length() != 0) {
            this.setSeed(Integer.parseInt(sSeed));
        }
        this.setUseMutation(Utils.getFlag('M', options));
        this.setUseCrossOver(Utils.getFlag('C', options));
        this.setUseTournamentSelection(Utils.getFlag('O', options));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-L");
        options.add("" + this.getPopulationSize());
        options.add("-A");
        options.add("" + this.getDescendantPopulationSize());
        options.add("-U");
        options.add("" + this.getRuns());
        options.add("-R");
        options.add("" + this.getSeed());
        if (this.getUseMutation()) {
            options.add("-M");
        }
        if (this.getUseCrossOver()) {
            options.add("-C");
        }
        if (this.getUseTournamentSelection()) {
            options.add("-O");
        }
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    public boolean getUseCrossOver() {
        return this.m_bUseCrossOver;
    }

    public boolean getUseMutation() {
        return this.m_bUseMutation;
    }

    public int getDescendantPopulationSize() {
        return this.m_nDescendantPopulationSize;
    }

    public int getPopulationSize() {
        return this.m_nPopulationSize;
    }

    public void setUseCrossOver(boolean bUseCrossOver) {
        this.m_bUseCrossOver = bUseCrossOver;
    }

    public void setUseMutation(boolean bUseMutation) {
        this.m_bUseMutation = bUseMutation;
    }

    public boolean getUseTournamentSelection() {
        return this.m_bUseTournamentSelection;
    }

    public void setUseTournamentSelection(boolean bUseTournamentSelection) {
        this.m_bUseTournamentSelection = bUseTournamentSelection;
    }

    public void setDescendantPopulationSize(int iDescendantPopulationSize) {
        this.m_nDescendantPopulationSize = iDescendantPopulationSize;
    }

    public void setPopulationSize(int iPopulationSize) {
        this.m_nPopulationSize = iPopulationSize;
    }

    public int getSeed() {
        return this.m_nSeed;
    }

    public void setSeed(int nSeed) {
        this.m_nSeed = nSeed;
    }

    @Override
    public String globalInfo() {
        return "This Bayes Network learning algorithm uses genetic search for finding a well scoring Bayes network structure. Genetic search works by having a population of Bayes network structures and allow them to mutate and apply cross over to get offspring. The best network structure found during the process is returned.";
    }

    public String runsTipText() {
        return "Sets the number of generations of Bayes network structure populations.";
    }

    public String seedTipText() {
        return "Initialization value for random number generator. Setting the seed allows replicability of experiments.";
    }

    public String populationSizeTipText() {
        return "Sets the size of the population of network structures that is selected each generation.";
    }

    public String descendantPopulationSizeTipText() {
        return "Sets the size of the population of descendants that is created each generation.";
    }

    public String useMutationTipText() {
        return "Determines whether mutation is allowed. Mutation flips a bit in the bit representation of the network structure. At least one of mutation or cross-over should be used.";
    }

    public String useCrossOverTipText() {
        return "Determines whether cross-over is allowed. Cross over combined the bit representations of network structure by taking a random first k bits of oneand adding the remainder of the other. At least one of mutation or cross-over should be used.";
    }

    public String useTournamentSelectionTipText() {
        return "Determines the method of selecting a population. When set to true, tournament selection is used (pick two at random and the highest is allowed to continue). When set to false, the top scoring network structures are selected.";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10154 $");
    }

    class BayesNetRepresentation
    implements RevisionHandler {
        int m_nNodes = 0;
        boolean[] m_bits;
        double m_fScore = 0.0;

        public double getScore() {
            return this.m_fScore;
        }

        BayesNetRepresentation(int nNodes) {
            this.m_nNodes = nNodes;
        }

        public void randomInit() {
            do {
                this.m_bits = new boolean[this.m_nNodes * this.m_nNodes];
                int i = 0;
                while (i < this.m_nNodes) {
                    int iPos;
                    while (this.isSquare(iPos = GeneticSearch.this.m_random.nextInt(this.m_nNodes * this.m_nNodes))) {
                    }
                    this.m_bits[iPos] = true;
                    ++i;
                }
            } while (this.hasCycles());
            this.calcGlobalScore();
        }

        void calcGlobalScore() {
            ParentSet parentSet;
            int iNode = 0;
            while (iNode < this.m_nNodes) {
                parentSet = GeneticSearch.this.m_BayesNet.getParentSet(iNode);
                while (parentSet.getNrOfParents() > 0) {
                    parentSet.deleteLastParent(GeneticSearch.this.m_BayesNet.m_Instances);
                }
                ++iNode;
            }
            iNode = 0;
            while (iNode < this.m_nNodes) {
                parentSet = GeneticSearch.this.m_BayesNet.getParentSet(iNode);
                int iNode2 = 0;
                while (iNode2 < this.m_nNodes) {
                    if (this.m_bits[iNode2 + iNode * this.m_nNodes]) {
                        parentSet.addParent(iNode2, GeneticSearch.this.m_BayesNet.m_Instances);
                    }
                    ++iNode2;
                }
                ++iNode;
            }
            try {
                this.m_fScore = GeneticSearch.this.calcScore(GeneticSearch.this.m_BayesNet);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean hasCycles() {
            boolean[] bDone = new boolean[this.m_nNodes];
            int iNode = 0;
            while (iNode < this.m_nNodes) {
                boolean bFound = false;
                int iNode2 = 0;
                while (!bFound && iNode2 < this.m_nNodes) {
                    if (!bDone[iNode2]) {
                        boolean bHasNoParents = true;
                        int iParent = 0;
                        while (iParent < this.m_nNodes) {
                            if (this.m_bits[iParent + iNode2 * this.m_nNodes] && !bDone[iParent]) {
                                bHasNoParents = false;
                            }
                            ++iParent;
                        }
                        if (bHasNoParents) {
                            bDone[iNode2] = true;
                            bFound = true;
                        }
                    }
                    ++iNode2;
                }
                if (!bFound) {
                    return true;
                }
                ++iNode;
            }
            return false;
        }

        BayesNetRepresentation copy() {
            BayesNetRepresentation b = new BayesNetRepresentation(this.m_nNodes);
            b.m_bits = new boolean[this.m_bits.length];
            int i = 0;
            while (i < this.m_nNodes * this.m_nNodes) {
                b.m_bits[i] = this.m_bits[i];
                ++i;
            }
            b.m_fScore = this.m_fScore;
            return b;
        }

        void mutate() {
            while (true) {
                int iBit;
                if (this.isSquare(iBit = GeneticSearch.this.m_random.nextInt(this.m_nNodes * this.m_nNodes))) {
                    continue;
                }
                boolean bl = this.m_bits[iBit] = !this.m_bits[iBit];
                if (!this.hasCycles()) break;
            }
            this.calcGlobalScore();
        }

        void crossOver(BayesNetRepresentation other) {
            boolean[] bits = new boolean[this.m_bits.length];
            int i = 0;
            while (i < this.m_bits.length) {
                bits[i] = this.m_bits[i];
                ++i;
            }
            int iCrossOverPoint = this.m_bits.length;
            do {
                int i2 = iCrossOverPoint;
                while (i2 < this.m_bits.length) {
                    this.m_bits[i2] = bits[i2];
                    ++i2;
                }
                i2 = iCrossOverPoint = GeneticSearch.this.m_random.nextInt(this.m_bits.length);
                while (i2 < this.m_bits.length) {
                    this.m_bits[i2] = other.m_bits[i2];
                    ++i2;
                }
            } while (this.hasCycles());
            this.calcGlobalScore();
        }

        boolean isSquare(int nNum) {
            if (g_bIsSquare == null || g_bIsSquare.length < nNum) {
                g_bIsSquare = new boolean[this.m_nNodes * this.m_nNodes];
                int i = 0;
                while (i < this.m_nNodes) {
                    GeneticSearch.g_bIsSquare[i * this.m_nNodes + i] = true;
                    ++i;
                }
            }
            return g_bIsSquare[nNum];
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 10154 $");
        }
    }
}

