/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc;

import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SerializationHelper;
import weka.core.Utils;

public class SerializedClassifier
extends AbstractClassifier {
    private static final long serialVersionUID = 4599593909947628642L;
    protected transient Classifier m_Model = null;
    protected File m_ModelFile = new File(System.getProperty("user.dir"));

    public String globalInfo() {
        return "A wrapper around a serialized classifier model. This classifier loads a serialized models and uses it to make predictions.\n\nWarning: since the serialized model doesn't get changed, cross-validation cannot bet used with this classifier.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe file containing the serialized model.\n\t(required)", "model", 1, "-model <filename>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-model");
        result.add("" + this.getModelFile());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption("model", options);
        if (tmpStr.length() != 0) {
            this.setModelFile(new File(tmpStr));
        } else {
            this.setModelFile(new File(System.getProperty("user.dir")));
        }
    }

    public String modelFileTipText() {
        return "The serialized classifier model to use for predictions.";
    }

    public File getModelFile() {
        return this.m_ModelFile;
    }

    public void setModelFile(File value) {
        this.m_ModelFile = value;
        if (value.exists() && value.isFile()) {
            try {
                this.initModel();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot load model from file '" + value + "': " + e);
            }
        }
    }

    public void setModel(Classifier value) {
        this.m_Model = value;
    }

    public Classifier getCurrentModel() {
        return this.m_Model;
    }

    protected void initModel() throws Exception {
        if (this.m_Model == null) {
            this.m_Model = (Classifier)SerializationHelper.read(this.m_ModelFile.getAbsolutePath());
        }
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result;
        if (this.m_ModelFile != null && this.m_ModelFile.exists() && this.m_ModelFile.isFile()) {
            try {
                this.initModel();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        if (this.m_Model != null) {
            result = this.m_Model.getCapabilities();
        } else {
            result = new Capabilities(this);
            result.disableAll();
        }
        Capabilities.Capability[] capabilityArray = Capabilities.Capability.values();
        int n = capabilityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Capabilities.Capability cap = capabilityArray[n2];
            result.enableDependency(cap);
            ++n2;
        }
        result.setOwner(this);
        return result;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        this.initModel();
        double[] result = this.m_Model.distributionForInstance(instance);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.initModel();
        this.getCapabilities().testWithFail(data);
    }

    public String toString() {
        StringBuffer result;
        if (this.m_Model == null) {
            result = new StringBuffer("No model loaded yet.");
        } else {
            result = new StringBuffer();
            result.append("SerializedClassifier\n");
            result.append("====================\n\n");
            result.append("File: " + this.getModelFile() + "\n\n");
            result.append(this.m_Model.toString());
        }
        return result.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10153 $");
    }

    public static void main(String[] args) {
        SerializedClassifier.runClassifier(new SerializedClassifier(), args);
    }
}

