/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.PairedStats;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixCSV;
import weka.experiment.ResultMatrixHTML;
import weka.experiment.ResultMatrixLatex;
import weka.experiment.ResultMatrixPlainText;
import weka.experiment.ResultMatrixSignificance;
import weka.experiment.Tester;

public class PairedTTester
implements OptionHandler,
Tester,
RevisionHandler {
    static final long serialVersionUID = 8370014624008728610L;
    protected Instances m_Instances;
    protected int m_RunColumn = 0;
    protected int m_RunColumnSet = -1;
    protected int m_FoldColumn = -1;
    protected int m_SortColumn = -1;
    protected int[] m_SortOrder = null;
    protected int[] m_ColOrder = null;
    protected double m_SignificanceLevel = 0.05;
    protected Range m_DatasetKeyColumnsRange = new Range();
    protected int[] m_DatasetKeyColumns;
    protected DatasetSpecifiers m_DatasetSpecifiers = new DatasetSpecifiers();
    protected Range m_ResultsetKeyColumnsRange = new Range();
    protected int[] m_ResultsetKeyColumns;
    protected int[] m_DisplayedResultsets = null;
    protected ArrayList<Resultset> m_Resultsets = new ArrayList();
    protected boolean m_ResultsetsValid;
    protected boolean m_ShowStdDevs = false;
    protected ResultMatrix m_ResultMatrix = new ResultMatrixPlainText();

    protected String templateString(Instance template) {
        String result = "";
        int[] nArray = this.m_DatasetKeyColumns;
        int n = this.m_DatasetKeyColumns.length;
        int n2 = 0;
        while (n2 < n) {
            int m_DatasetKeyColumn = nArray[n2];
            result = String.valueOf(result) + template.toString(m_DatasetKeyColumn) + ' ';
            ++n2;
        }
        if (result.startsWith("weka.classifiers.")) {
            result = result.substring("weka.classifiers.".length());
        }
        return result.trim();
    }

    @Override
    public void setResultMatrix(ResultMatrix matrix) {
        this.m_ResultMatrix = matrix;
    }

    @Override
    public ResultMatrix getResultMatrix() {
        return this.m_ResultMatrix;
    }

    @Override
    public void setShowStdDevs(boolean s) {
        this.m_ShowStdDevs = s;
    }

    @Override
    public boolean getShowStdDevs() {
        return this.m_ShowStdDevs;
    }

    protected void prepareData() throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No instances have been set");
        }
        this.m_RunColumn = this.m_RunColumnSet == -1 ? this.m_Instances.numAttributes() - 1 : this.m_RunColumnSet;
        if (this.m_ResultsetKeyColumnsRange == null) {
            throw new Exception("No result specifier columns have been set");
        }
        this.m_ResultsetKeyColumnsRange.setUpper(this.m_Instances.numAttributes() - 1);
        this.m_ResultsetKeyColumns = this.m_ResultsetKeyColumnsRange.getSelection();
        if (this.m_DatasetKeyColumnsRange == null) {
            throw new Exception("No dataset specifier columns have been set");
        }
        this.m_DatasetKeyColumnsRange.setUpper(this.m_Instances.numAttributes() - 1);
        this.m_DatasetKeyColumns = this.m_DatasetKeyColumnsRange.getSelection();
        this.m_Resultsets.clear();
        this.m_DatasetSpecifiers.removeAllSpecifiers();
        int i = 0;
        while (i < this.m_Instances.numInstances()) {
            Instance current = this.m_Instances.instance(i);
            if (current.isMissing(this.m_RunColumn)) {
                throw new Exception("Instance has missing value in run column!\n" + current);
            }
            int[] nArray = this.m_ResultsetKeyColumns;
            int n = this.m_ResultsetKeyColumns.length;
            int n2 = 0;
            while (n2 < n) {
                int m_ResultsetKeyColumn = nArray[n2];
                if (current.isMissing(m_ResultsetKeyColumn)) {
                    throw new Exception("Instance has missing value in resultset key column " + (m_ResultsetKeyColumn + 1) + "!\n" + current);
                }
                ++n2;
            }
            nArray = this.m_DatasetKeyColumns;
            n = this.m_DatasetKeyColumns.length;
            n2 = 0;
            while (n2 < n) {
                int m_DatasetKeyColumn = nArray[n2];
                if (current.isMissing(m_DatasetKeyColumn)) {
                    throw new Exception("Instance has missing value in dataset key column " + (m_DatasetKeyColumn + 1) + "!\n" + current);
                }
                ++n2;
            }
            boolean found = false;
            int j = 0;
            while (j < this.m_Resultsets.size()) {
                Resultset resultset = this.m_Resultsets.get(j);
                if (resultset.matchesTemplate(current)) {
                    resultset.add(current);
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                Resultset resultset = new Resultset(current);
                this.m_Resultsets.add(resultset);
            }
            this.m_DatasetSpecifiers.add(current);
            ++i;
        }
        int j = 0;
        while (j < this.m_Resultsets.size()) {
            Resultset resultset = this.m_Resultsets.get(j);
            if (this.m_FoldColumn >= 0) {
                resultset.sort(this.m_FoldColumn);
            }
            resultset.sort(this.m_RunColumn);
            ++j;
        }
        this.m_ResultsetsValid = true;
    }

    @Override
    public int getNumDatasets() {
        if (!this.m_ResultsetsValid) {
            try {
                this.prepareData();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return 0;
            }
        }
        return this.m_DatasetSpecifiers.numSpecifiers();
    }

    @Override
    public int getNumResultsets() {
        if (!this.m_ResultsetsValid) {
            try {
                this.prepareData();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return 0;
            }
        }
        return this.m_Resultsets.size();
    }

    @Override
    public String getResultsetName(int index) {
        if (!this.m_ResultsetsValid) {
            try {
                this.prepareData();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return this.m_Resultsets.get(index).templateString();
    }

    @Override
    public boolean displayResultset(int index) {
        boolean result = true;
        if (this.m_DisplayedResultsets != null) {
            result = false;
            int i = 0;
            while (i < this.m_DisplayedResultsets.length) {
                if (this.m_DisplayedResultsets[i] == index) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public PairedStats calculateStatistics(Instance datasetSpecifier, int resultset1Index, int resultset2Index, int comparisonColumn) throws Exception {
        if (this.m_Instances.attribute(comparisonColumn).type() != 0) {
            throw new Exception("Comparison column " + (comparisonColumn + 1) + " (" + this.m_Instances.attribute(comparisonColumn).name() + ") is not numeric");
        }
        if (!this.m_ResultsetsValid) {
            this.prepareData();
        }
        Resultset resultset1 = this.m_Resultsets.get(resultset1Index);
        Resultset resultset2 = this.m_Resultsets.get(resultset2Index);
        ArrayList<Instance> dataset1 = resultset1.dataset(datasetSpecifier);
        ArrayList<Instance> dataset2 = resultset2.dataset(datasetSpecifier);
        String datasetName = this.templateString(datasetSpecifier);
        if (dataset1 == null) {
            throw new Exception("No results for dataset=" + datasetName + " for resultset=" + resultset1.templateString());
        }
        if (dataset2 == null) {
            throw new Exception("No results for dataset=" + datasetName + " for resultset=" + resultset2.templateString());
        }
        if (dataset1.size() != dataset2.size()) {
            throw new Exception("Results for dataset=" + datasetName + " differ in size for resultset=" + resultset1.templateString() + " and resultset=" + resultset2.templateString());
        }
        PairedStats pairedStats = new PairedStats(this.m_SignificanceLevel);
        int k = 0;
        while (k < dataset1.size()) {
            Instance current1 = dataset1.get(k);
            Instance current2 = dataset2.get(k);
            if (current1.isMissing(comparisonColumn)) {
                System.err.println("Instance has missing value in comparison column!\n" + current1);
            } else if (current2.isMissing(comparisonColumn)) {
                System.err.println("Instance has missing value in comparison column!\n" + current2);
            } else {
                if (current1.value(this.m_RunColumn) != current2.value(this.m_RunColumn)) {
                    System.err.println("Run numbers do not match!\n" + current1 + current2);
                }
                if (this.m_FoldColumn != -1 && current1.value(this.m_FoldColumn) != current2.value(this.m_FoldColumn)) {
                    System.err.println("Fold numbers do not match!\n" + current1 + current2);
                }
                double value1 = current1.value(comparisonColumn);
                double value2 = current2.value(comparisonColumn);
                pairedStats.add(value1, value2);
            }
            ++k;
        }
        pairedStats.calculateDerived();
        return pairedStats;
    }

    @Override
    public String resultsetKey() {
        if (!this.m_ResultsetsValid) {
            try {
                this.prepareData();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return ex.getMessage();
            }
        }
        String result = "";
        int j = 0;
        while (j < this.getNumResultsets()) {
            result = String.valueOf(result) + "(" + (j + 1) + ") " + this.getResultsetName(j) + '\n';
            ++j;
        }
        return String.valueOf(result) + '\n';
    }

    @Override
    public String header(int comparisonColumn) {
        if (!this.m_ResultsetsValid) {
            try {
                this.prepareData();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return ex.getMessage();
            }
        }
        this.initResultMatrix();
        this.m_ResultMatrix.addHeader("Tester", this.getClass().getName());
        this.m_ResultMatrix.addHeader("Analysing", this.m_Instances.attribute(comparisonColumn).name());
        this.m_ResultMatrix.addHeader("Datasets", Integer.toString(this.getNumDatasets()));
        this.m_ResultMatrix.addHeader("Resultsets", Integer.toString(this.getNumResultsets()));
        this.m_ResultMatrix.addHeader("Confidence", String.valueOf(this.getSignificanceLevel()) + " (two tailed)");
        this.m_ResultMatrix.addHeader("Sorted by", this.getSortColumnName());
        this.m_ResultMatrix.addHeader("Date", new SimpleDateFormat().format(new Date()));
        return String.valueOf(this.m_ResultMatrix.toStringHeader()) + "\n";
    }

    @Override
    public int[][] multiResultsetWins(int comparisonColumn, int[][] nonSigWin) throws Exception {
        int numResultsets = this.getNumResultsets();
        int[][] win = new int[numResultsets][numResultsets];
        int i = 0;
        while (i < numResultsets) {
            int j = i + 1;
            while (j < numResultsets) {
                System.err.print("Comparing (" + (i + 1) + ") with (" + (j + 1) + ")\r");
                System.err.flush();
                int k = 0;
                while (k < this.getNumDatasets()) {
                    try {
                        PairedStats pairedStats = this.calculateStatistics(this.m_DatasetSpecifiers.specifier(k), i, j, comparisonColumn);
                        if (pairedStats.differencesSignificance < 0) {
                            int[] nArray = win[i];
                            int n = j;
                            nArray[n] = nArray[n] + 1;
                        } else if (pairedStats.differencesSignificance > 0) {
                            int[] nArray = win[j];
                            int n = i;
                            nArray[n] = nArray[n] + 1;
                        }
                        if (pairedStats.differencesStats.mean < 0.0) {
                            int[] nArray = nonSigWin[i];
                            int n = j;
                            nArray[n] = nArray[n] + 1;
                        } else if (pairedStats.differencesStats.mean > 0.0) {
                            int[] nArray = nonSigWin[j];
                            int n = i;
                            nArray[n] = nArray[n] + 1;
                        }
                    }
                    catch (Exception ex) {
                        System.err.println(ex.getMessage());
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return win;
    }

    protected void initResultMatrix() {
        this.m_ResultMatrix.setSize(this.getNumResultsets(), this.getNumDatasets());
        this.m_ResultMatrix.setShowStdDev(this.m_ShowStdDevs);
        int i = 0;
        while (i < this.getNumDatasets()) {
            this.m_ResultMatrix.setRowName(i, this.templateString(this.m_DatasetSpecifiers.specifier(i)));
            ++i;
        }
        int j = 0;
        while (j < this.getNumResultsets()) {
            this.m_ResultMatrix.setColName(j, this.getResultsetName(j));
            this.m_ResultMatrix.setColHidden(j, !this.displayResultset(j));
            ++j;
        }
    }

    @Override
    public String multiResultsetSummary(int comparisonColumn) throws Exception {
        int[][] nonSigWin = new int[this.getNumResultsets()][this.getNumResultsets()];
        int[][] win = this.multiResultsetWins(comparisonColumn, nonSigWin);
        this.initResultMatrix();
        this.m_ResultMatrix.setSummary(nonSigWin, win);
        return this.m_ResultMatrix.toStringSummary();
    }

    @Override
    public String multiResultsetRanking(int comparisonColumn) throws Exception {
        int[][] nonSigWin = new int[this.getNumResultsets()][this.getNumResultsets()];
        int[][] win = this.multiResultsetWins(comparisonColumn, nonSigWin);
        this.initResultMatrix();
        this.m_ResultMatrix.setRanking(win);
        return this.m_ResultMatrix.toStringRanking();
    }

    @Override
    public String multiResultsetFull(int baseResultset, int comparisonColumn) throws Exception {
        int maxWidthMean = 2;
        int maxWidthStdDev = 2;
        double[] sortValues = new double[this.getNumDatasets()];
        int i = 0;
        while (i < this.getNumDatasets()) {
            sortValues[i] = Double.POSITIVE_INFINITY;
            int j = 0;
            while (j < this.getNumResultsets()) {
                if (this.displayResultset(j)) {
                    try {
                        double width;
                        PairedStats pairedStats = this.calculateStatistics(this.m_DatasetSpecifiers.specifier(i), baseResultset, j, comparisonColumn);
                        if (!Double.isInfinite(pairedStats.yStats.mean) && !Double.isNaN(pairedStats.yStats.mean) && (width = Math.log(Math.abs(pairedStats.yStats.mean)) / Math.log(10.0) + 1.0) > (double)maxWidthMean) {
                            maxWidthMean = (int)width;
                        }
                        if (j == baseResultset) {
                            sortValues[i] = this.getSortColumn() != -1 ? this.calculateStatistics((Instance)this.m_DatasetSpecifiers.specifier((int)i), (int)baseResultset, (int)j, (int)this.getSortColumn()).xStats.mean : (double)i;
                        }
                        if (this.m_ShowStdDevs && !Double.isInfinite(pairedStats.yStats.stdDev) && !Double.isNaN(pairedStats.yStats.stdDev) && (width = Math.log(Math.abs(pairedStats.yStats.stdDev)) / Math.log(10.0) + 1.0) > (double)maxWidthStdDev) {
                            maxWidthStdDev = (int)width;
                        }
                    }
                    catch (Exception ex) {
                        System.err.println(ex);
                    }
                }
                ++j;
            }
            ++i;
        }
        this.m_SortOrder = Utils.sort(sortValues);
        this.m_ColOrder = new int[this.getNumResultsets()];
        this.m_ColOrder[0] = baseResultset;
        int index = 1;
        int i2 = 0;
        while (i2 < this.getNumResultsets()) {
            if (i2 != baseResultset) {
                this.m_ColOrder[index] = i2;
                ++index;
            }
            ++i2;
        }
        this.initResultMatrix();
        this.m_ResultMatrix.setRowOrder(this.m_SortOrder);
        this.m_ResultMatrix.setColOrder(this.m_ColOrder);
        this.m_ResultMatrix.setMeanWidth(maxWidthMean);
        this.m_ResultMatrix.setStdDevWidth(maxWidthStdDev);
        this.m_ResultMatrix.setSignificanceWidth(1);
        i2 = 0;
        while (i2 < this.m_ResultMatrix.getColCount()) {
            if (i2 == baseResultset && this.m_ResultMatrix.getColHidden(i2)) {
                this.m_ResultMatrix.setColHidden(i2, false);
                System.err.println("Note: test base was hidden - set visible!");
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.getNumDatasets()) {
            this.m_ResultMatrix.setRowName(i2, this.templateString(this.m_DatasetSpecifiers.specifier(i2)));
            int j = 0;
            while (j < this.getNumResultsets()) {
                try {
                    PairedStats pairedStats = this.calculateStatistics(this.m_DatasetSpecifiers.specifier(i2), baseResultset, j, comparisonColumn);
                    this.m_ResultMatrix.setCount(i2, pairedStats.count);
                    this.m_ResultMatrix.setMean(j, i2, pairedStats.yStats.mean);
                    this.m_ResultMatrix.setStdDev(j, i2, pairedStats.yStats.stdDev);
                    if (pairedStats.differencesSignificance < 0) {
                        this.m_ResultMatrix.setSignificance(j, i2, 1);
                    } else if (pairedStats.differencesSignificance > 0) {
                        this.m_ResultMatrix.setSignificance(j, i2, 2);
                    } else {
                        this.m_ResultMatrix.setSignificance(j, i2, 0);
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
                ++j;
            }
            ++i2;
        }
        StringBuffer result = new StringBuffer(1000);
        try {
            result.append(this.m_ResultMatrix.toStringMatrix());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        result.append("\n\n" + this.m_ResultMatrix.toStringKey());
        return result.toString();
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tSpecify list of columns that specify a unique\n\tdataset.\n\tFirst and last are valid indexes. (default none)", "D", 1, "-D <index,index2-index4,...>"));
        newVector.addElement(new Option("\tSet the index of the column containing the run number", "R", 1, "-R <index>"));
        newVector.addElement(new Option("\tSet the index of the column containing the fold number", "F", 1, "-F <index>"));
        newVector.addElement(new Option("\tSpecify list of columns that specify a unique\n\t'result generator' (eg: classifier name and options).\n\tFirst and last are valid indexes. (default none)", "G", 1, "-G <index1,index2-index4,...>"));
        newVector.addElement(new Option("\tSet the significance level for comparisons (default 0.05)", "S", 1, "-S <significance level>"));
        newVector.addElement(new Option("\tShow standard deviations", "V", 0, "-V"));
        newVector.addElement(new Option("\tProduce table comparisons in Latex table format", "L", 0, "-L"));
        newVector.addElement(new Option("\tProduce table comparisons in CSV table format", "csv", 0, "-csv"));
        newVector.addElement(new Option("\tProduce table comparisons in HTML table format", "html", 0, "-html"));
        newVector.addElement(new Option("\tProduce table comparisons with only the significance values", "significance", 0, "-significance"));
        newVector.addElement(new Option("\tProduce table comparisons output suitable for GNUPlot", "gnuplot", 0, "-gnuplot"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setShowStdDevs(Utils.getFlag('V', options));
        if (Utils.getFlag('L', options)) {
            this.setResultMatrix(new ResultMatrixLatex());
        }
        if (Utils.getFlag("csv", options)) {
            this.setResultMatrix(new ResultMatrixCSV());
        }
        if (Utils.getFlag("html", options)) {
            this.setResultMatrix(new ResultMatrixHTML());
        }
        if (Utils.getFlag("significance", options)) {
            this.setResultMatrix(new ResultMatrixSignificance());
        }
        String datasetList = Utils.getOption('D', options);
        Range datasetRange = new Range();
        if (datasetList.length() != 0) {
            datasetRange.setRanges(datasetList);
        }
        this.setDatasetKeyColumns(datasetRange);
        String indexStr = Utils.getOption('R', options);
        if (indexStr.length() != 0) {
            if (indexStr.equals("first")) {
                this.setRunColumn(0);
            } else if (indexStr.equals("last")) {
                this.setRunColumn(-1);
            } else {
                this.setRunColumn(Integer.parseInt(indexStr) - 1);
            }
        } else {
            this.setRunColumn(-1);
        }
        String foldStr = Utils.getOption('F', options);
        if (foldStr.length() != 0) {
            this.setFoldColumn(Integer.parseInt(foldStr) - 1);
        } else {
            this.setFoldColumn(-1);
        }
        String sigStr = Utils.getOption('S', options);
        if (sigStr.length() != 0) {
            this.setSignificanceLevel(new Double(sigStr));
        } else {
            this.setSignificanceLevel(0.05);
        }
        String resultsetList = Utils.getOption('G', options);
        Range generatorRange = new Range();
        if (resultsetList.length() != 0) {
            generatorRange.setRanges(resultsetList);
        }
        this.setResultsetKeyColumns(generatorRange);
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[11];
        int current = 0;
        if (!this.getResultsetKeyColumns().getRanges().equals("")) {
            options[current++] = "-G";
            options[current++] = this.getResultsetKeyColumns().getRanges();
        }
        if (!this.getDatasetKeyColumns().getRanges().equals("")) {
            options[current++] = "-D";
            options[current++] = this.getDatasetKeyColumns().getRanges();
        }
        options[current++] = "-R";
        options[current++] = "" + (this.getRunColumn() + 1);
        options[current++] = "-S";
        options[current++] = "" + this.getSignificanceLevel();
        if (this.getShowStdDevs()) {
            options[current++] = "-V";
        }
        if (this.getResultMatrix() instanceof ResultMatrixLatex) {
            options[current++] = "-L";
        }
        if (this.getResultMatrix() instanceof ResultMatrixCSV) {
            options[current++] = "-csv";
        }
        if (this.getResultMatrix() instanceof ResultMatrixHTML) {
            options[current++] = "-html";
        }
        if (this.getResultMatrix() instanceof ResultMatrixSignificance) {
            options[current++] = "-significance";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public Range getResultsetKeyColumns() {
        return this.m_ResultsetKeyColumnsRange;
    }

    @Override
    public void setResultsetKeyColumns(Range newResultsetKeyColumns) {
        this.m_ResultsetKeyColumnsRange = newResultsetKeyColumns;
        this.m_ResultsetsValid = false;
    }

    @Override
    public int[] getDisplayedResultsets() {
        return this.m_DisplayedResultsets;
    }

    @Override
    public void setDisplayedResultsets(int[] cols) {
        this.m_DisplayedResultsets = cols;
    }

    @Override
    public double getSignificanceLevel() {
        return this.m_SignificanceLevel;
    }

    @Override
    public void setSignificanceLevel(double newSignificanceLevel) {
        this.m_SignificanceLevel = newSignificanceLevel;
    }

    @Override
    public Range getDatasetKeyColumns() {
        return this.m_DatasetKeyColumnsRange;
    }

    @Override
    public void setDatasetKeyColumns(Range newDatasetKeyColumns) {
        this.m_DatasetKeyColumnsRange = newDatasetKeyColumns;
        this.m_ResultsetsValid = false;
    }

    @Override
    public int getRunColumn() {
        return this.m_RunColumnSet;
    }

    @Override
    public void setRunColumn(int newRunColumn) {
        this.m_RunColumnSet = newRunColumn;
        this.m_ResultsetsValid = false;
    }

    @Override
    public int getFoldColumn() {
        return this.m_FoldColumn;
    }

    @Override
    public void setFoldColumn(int newFoldColumn) {
        this.m_FoldColumn = newFoldColumn;
        this.m_ResultsetsValid = false;
    }

    @Override
    public String getSortColumnName() {
        if (this.getSortColumn() == -1) {
            return "-";
        }
        return this.m_Instances.attribute(this.getSortColumn()).name();
    }

    @Override
    public int getSortColumn() {
        return this.m_SortColumn;
    }

    @Override
    public void setSortColumn(int newSortColumn) {
        if (newSortColumn >= -1) {
            this.m_SortColumn = newSortColumn;
        }
    }

    @Override
    public Instances getInstances() {
        return this.m_Instances;
    }

    @Override
    public void setInstances(Instances newInstances) {
        this.m_Instances = newInstances;
        this.m_ResultsetsValid = false;
    }

    @Override
    public void assign(Tester tester) {
        this.setInstances(tester.getInstances());
        this.setResultMatrix(tester.getResultMatrix());
        this.setShowStdDevs(tester.getShowStdDevs());
        this.setResultsetKeyColumns(tester.getResultsetKeyColumns());
        this.setDisplayedResultsets(tester.getDisplayedResultsets());
        this.setSignificanceLevel(tester.getSignificanceLevel());
        this.setDatasetKeyColumns(tester.getDatasetKeyColumns());
        this.setRunColumn(tester.getRunColumn());
        this.setFoldColumn(tester.getFoldColumn());
        this.setSortColumn(tester.getSortColumn());
    }

    @Override
    public String getToolTipText() {
        return "Performs test using t-test statistic";
    }

    @Override
    public String getDisplayName() {
        return "Paired T-Tester";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10203 $");
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        try {
            block14: {
                tt = new PairedTTester();
                datasetName = Utils.getOption('t', args);
                compareColStr = Utils.getOption('c', args);
                baseColStr = Utils.getOption('b', args);
                summaryOnly = Utils.getFlag('s', args);
                rankingOnly = Utils.getFlag('r', args);
                try {
                    if (datasetName.length() == 0 || compareColStr.length() == 0) {
                        throw new Exception("-t and -c options are required");
                    }
                    tt.setOptions(args);
                    Utils.checkForRemainingOptions(args);
                    break block14;
                }
                catch (Exception ex) {
                    result = "";
                    enu = tt.listOptions();
                    ** while (enu.hasMoreElements())
                }
lbl-1000:
                // 1 sources

                {
                    option = enu.nextElement();
                    result = String.valueOf(result) + option.synopsis() + '\n' + option.description() + '\n';
                    continue;
                }
lbl21:
                // 1 sources

                throw new Exception("Usage:\n\n-t <file>\n\tSet the dataset containing data to evaluate\n-b <index>\n\tSet the resultset to base comparisons against (optional)\n-c <index>\n\tSet the column to perform a comparison on\n-s\n\tSummarize wins over all resultset pairs\n\n-r\n\tGenerate a resultset ranking\n\n" + result);
            }
            data = new Instances(new BufferedReader(new FileReader(datasetName)));
            tt.setInstances(data);
            compareCol = Integer.parseInt(compareColStr) - 1;
            System.out.println(tt.header(compareCol));
            if (rankingOnly) {
                System.out.println(tt.multiResultsetRanking(compareCol));
            } else if (summaryOnly) {
                System.out.println(tt.multiResultsetSummary(compareCol));
            } else {
                System.out.println(tt.resultsetKey());
                if (baseColStr.length() == 0) {
                    i = 0;
                    while (i < tt.getNumResultsets()) {
                        if (tt.displayResultset(i)) {
                            System.out.println(tt.multiResultsetFull(i, compareCol));
                        }
                        ++i;
                    }
                } else {
                    baseCol = Integer.parseInt(baseColStr) - 1;
                    System.out.println(tt.multiResultsetFull(baseCol, compareCol));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
    }

    protected class Dataset
    implements RevisionHandler,
    Serializable {
        private static final long serialVersionUID = -2801397601839433282L;
        Instance m_Template;
        ArrayList<Instance> m_Dataset;

        public Dataset(Instance template) {
            this.m_Template = template;
            this.m_Dataset = new ArrayList();
            this.add(template);
        }

        protected boolean matchesTemplate(Instance first) {
            int[] nArray = PairedTTester.this.m_DatasetKeyColumns;
            int n = PairedTTester.this.m_DatasetKeyColumns.length;
            int n2 = 0;
            while (n2 < n) {
                int m_DatasetKeyColumn = nArray[n2];
                if (first.value(m_DatasetKeyColumn) != this.m_Template.value(m_DatasetKeyColumn)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        protected void add(Instance inst) {
            this.m_Dataset.add(inst);
        }

        protected ArrayList<Instance> contents() {
            return this.m_Dataset;
        }

        public void sort(int runColumn) {
            double[] runNums = new double[this.m_Dataset.size()];
            int j = 0;
            while (j < runNums.length) {
                runNums[j] = this.m_Dataset.get(j).value(runColumn);
                ++j;
            }
            int[] index = Utils.stableSort(runNums);
            ArrayList<Instance> newDataset = new ArrayList<Instance>(runNums.length);
            int[] nArray = index;
            int n = index.length;
            int n2 = 0;
            while (n2 < n) {
                int element = nArray[n2];
                newDataset.add(this.m_Dataset.get(element));
                ++n2;
            }
            this.m_Dataset = newDataset;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 10203 $");
        }
    }

    protected class DatasetSpecifiers
    implements RevisionHandler,
    Serializable {
        private static final long serialVersionUID = -9020938059902723401L;
        ArrayList<Instance> m_Specifiers = new ArrayList();

        protected DatasetSpecifiers() {
        }

        protected void removeAllSpecifiers() {
            this.m_Specifiers.clear();
        }

        protected void add(Instance inst) {
            int i = 0;
            while (i < this.m_Specifiers.size()) {
                Instance specifier = this.m_Specifiers.get(i);
                boolean found = true;
                int[] nArray = PairedTTester.this.m_DatasetKeyColumns;
                int n = PairedTTester.this.m_DatasetKeyColumns.length;
                int n2 = 0;
                while (n2 < n) {
                    int m_DatasetKeyColumn = nArray[n2];
                    if (inst.value(m_DatasetKeyColumn) != specifier.value(m_DatasetKeyColumn)) {
                        found = false;
                    }
                    ++n2;
                }
                if (found) {
                    return;
                }
                ++i;
            }
            this.m_Specifiers.add(inst);
        }

        protected Instance specifier(int i) {
            return this.m_Specifiers.get(i);
        }

        protected int numSpecifiers() {
            return this.m_Specifiers.size();
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 10203 $");
        }
    }

    protected class Resultset
    implements RevisionHandler,
    Serializable {
        private static final long serialVersionUID = 1543786683821339978L;
        Instance m_Template;
        ArrayList<Dataset> m_Datasets;

        public Resultset(Instance template) {
            this.m_Template = template;
            this.m_Datasets = new ArrayList();
            this.add(template);
        }

        protected boolean matchesTemplate(Instance first) {
            int[] nArray = PairedTTester.this.m_ResultsetKeyColumns;
            int n = PairedTTester.this.m_ResultsetKeyColumns.length;
            int n2 = 0;
            while (n2 < n) {
                int m_ResultsetKeyColumn = nArray[n2];
                if (first.value(m_ResultsetKeyColumn) != this.m_Template.value(m_ResultsetKeyColumn)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        protected String templateString() {
            String result = "";
            String tempResult = "";
            int[] nArray = PairedTTester.this.m_ResultsetKeyColumns;
            int n = PairedTTester.this.m_ResultsetKeyColumns.length;
            int n2 = 0;
            while (n2 < n) {
                int m_ResultsetKeyColumn = nArray[n2];
                tempResult = String.valueOf(this.m_Template.toString(m_ResultsetKeyColumn)) + ' ';
                tempResult = Utils.removeSubstring(tempResult, "weka.classifiers.");
                tempResult = Utils.removeSubstring(tempResult, "weka.filters.");
                tempResult = Utils.removeSubstring(tempResult, "weka.attributeSelection.");
                result = String.valueOf(result) + tempResult;
                ++n2;
            }
            return result.trim();
        }

        public ArrayList<Instance> dataset(Instance inst) {
            int i = 0;
            while (i < this.m_Datasets.size()) {
                if (this.m_Datasets.get(i).matchesTemplate(inst)) {
                    return this.m_Datasets.get(i).contents();
                }
                ++i;
            }
            return null;
        }

        public void add(Instance newInst) {
            int i = 0;
            while (i < this.m_Datasets.size()) {
                if (this.m_Datasets.get(i).matchesTemplate(newInst)) {
                    this.m_Datasets.get(i).add(newInst);
                    return;
                }
                ++i;
            }
            Dataset newDataset = new Dataset(newInst);
            this.m_Datasets.add(newDataset);
        }

        public void sort(int runColumn) {
            int i = 0;
            while (i < this.m_Datasets.size()) {
                this.m_Datasets.get(i).sort(runColumn);
                ++i;
            }
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 10203 $");
        }
    }
}

