/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.unsupervised.attribute.Discretize;

public class PKIDiscretize
extends Discretize
implements TechnicalInformationHandler {
    static final long serialVersionUID = 6153101248977702675L;

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        this.m_FindNumBins = true;
        return super.setInputFormat(instanceInfo);
    }

    @Override
    protected void findNumBins(int index) {
        Instances toFilter = this.getInputFormat();
        int numOfInstances = toFilter.numInstances();
        int i = 0;
        while (i < toFilter.numInstances()) {
            if (toFilter.instance(i).isMissing(index)) {
                --numOfInstances;
            }
            ++i;
        }
        this.m_NumBins = (int)Math.sqrt(numOfInstances);
        if (this.m_NumBins > 0) {
            this.calculateCutPointsByEqualFrequencyBinning(index);
        }
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tUnsets the class index temporarily before the filter is\n\tapplied to the data.\n\t(default: no)", "unset-class-temporarily", 1, "-unset-class-temporarily"));
        result.addElement(new Option("\tSpecifies list of columns to Discretize. First and last are valid indexes.\n\t(default: first-last)", "R", 1, "-R <col1,col2-col4,...>"));
        result.addElement(new Option("\tInvert matching sense of column indexes.", "V", 0, "-V"));
        result.addElement(new Option("\tOutput binary attributes for discretized attributes.", "D", 0, "-D"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setIgnoreClass(Utils.getFlag("unset-class-temporarily", options));
        this.setMakeBinary(Utils.getFlag('D', options));
        this.setInvertSelection(Utils.getFlag('V', options));
        String convertList = Utils.getOption('R', options);
        if (convertList.length() != 0) {
            this.setAttributeIndices(convertList);
        } else {
            this.setAttributeIndices("first-last");
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getMakeBinary()) {
            result.add("-D");
        }
        if (this.getInvertSelection()) {
            result.add("-V");
        }
        if (!this.getAttributeIndices().equals("")) {
            result.add("-R");
            result.add(this.getAttributeIndices());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String globalInfo() {
        return "Discretizes numeric attributes using equal frequency binning, where the number of bins is equal to the square root of the number of non-missing values.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Ying Yang and Geoffrey I. Webb");
        result.setValue(TechnicalInformation.Field.TITLE, "Proportional k-Interval Discretization for Naive-Bayes Classifiers");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "12th European Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.YEAR, "2001");
        result.setValue(TechnicalInformation.Field.PAGES, "564-575");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        result.setValue(TechnicalInformation.Field.SERIES, "LNCS");
        result.setValue(TechnicalInformation.Field.VOLUME, "2167");
        return result;
    }

    @Override
    public String findNumBinsTipText() {
        return "Ignored.";
    }

    @Override
    public boolean getFindNumBins() {
        return false;
    }

    @Override
    public void setFindNumBins(boolean newFindNumBins) {
    }

    @Override
    public String useEqualFrequencyTipText() {
        return "Always true.";
    }

    @Override
    public boolean getUseEqualFrequency() {
        return true;
    }

    @Override
    public void setUseEqualFrequency(boolean newUseEqualFrequency) {
    }

    @Override
    public String binsTipText() {
        return "Ignored.";
    }

    @Override
    public int getBins() {
        return 0;
    }

    @Override
    public void setBins(int numBins) {
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10215 $");
    }

    public static void main(String[] argv) {
        PKIDiscretize.runFilter(new PKIDiscretize(), argv);
    }
}

