/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.SwapValues;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataFormatListener;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.StructureProducer;
import weka.gui.beans.Visible;

public class ClassValuePicker
extends JPanel
implements Visible,
DataSourceListener,
BeanCommon,
EventConstraints,
Serializable,
StructureProducer {
    private static final long serialVersionUID = -1196143276710882989L;
    private String m_classValue;
    private Instances m_connectedFormat;
    private Object m_dataProvider;
    private final Vector<DataSourceListener> m_dataListeners = new Vector();
    private final Vector<DataFormatListener> m_dataFormatListeners = new Vector();
    protected transient Logger m_logger = null;
    protected BeanVisual m_visual = new BeanVisual("ClassValuePicker", "weka/gui/beans/icons/ClassValuePicker.gif", "weka/gui/beans/icons/ClassValuePicker_animated.gif");

    public String globalInfo() {
        return "Designate which class value is to be considered the \"positive\" class value (useful for ROC style curves).";
    }

    public ClassValuePicker() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    @Override
    public Instances getStructure(String eventName) {
        if (!eventName.equals("dataSet")) {
            return null;
        }
        if (this.m_dataProvider == null) {
            return null;
        }
        if (this.m_dataProvider != null && this.m_dataProvider instanceof StructureProducer) {
            this.m_connectedFormat = ((StructureProducer)this.m_dataProvider).getStructure("dataSet");
        }
        return this.m_connectedFormat;
    }

    protected Instances getStructure() {
        if (this.m_dataProvider != null) {
            return this.getStructure("dataSet");
        }
        return null;
    }

    public Instances getConnectedFormat() {
        return this.getStructure();
    }

    public void setClassValue(String value) {
        this.m_classValue = value;
        if (this.m_connectedFormat != null) {
            this.notifyDataFormatListeners();
        }
    }

    public String getClassValue() {
        return this.m_classValue;
    }

    @Override
    public void acceptDataSet(DataSetEvent e) {
        Instances dataSet;
        Instances newDataSet;
        if (e.isStructureOnly() && (this.m_connectedFormat == null || !this.m_connectedFormat.equalHeaders(e.getDataSet()))) {
            this.m_connectedFormat = new Instances(e.getDataSet(), 0);
            this.notifyDataFormatListeners();
        }
        if ((newDataSet = this.assignClassValue(dataSet = e.getDataSet())) != null) {
            e = new DataSetEvent(this, newDataSet);
            this.notifyDataListeners(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Instances assignClassValue(Instances dataSet) {
        block20: {
            if (dataSet.classIndex() < 0) {
                if (this.m_logger != null) {
                    this.m_logger.logMessage("[ClassValuePicker] " + this.statusMessagePrefix() + " No class attribute defined in data set.");
                    this.m_logger.statusMessage(String.valueOf(this.statusMessagePrefix()) + "WARNING: No class attribute defined in data set.");
                }
                return dataSet;
            }
            if (dataSet.classAttribute().isNumeric()) {
                if (this.m_logger != null) {
                    this.m_logger.logMessage("[ClassValuePicker] " + this.statusMessagePrefix() + " Class attribute must be nominal (ClassValuePicker)");
                    this.m_logger.statusMessage(String.valueOf(this.statusMessagePrefix()) + "WARNING: Class attribute must be nominal.");
                }
                return dataSet;
            }
            if (this.m_logger != null) {
                this.m_logger.statusMessage(String.valueOf(this.statusMessagePrefix()) + "remove");
            }
            if ((this.m_classValue == null || this.m_classValue.length() == 0) && dataSet.numInstances() > 0) {
                if (this.m_logger != null) {
                    this.m_logger.logMessage("[ClassValuePicker] " + this.statusMessagePrefix() + " Class value to consider as positive has not been set" + " (ClassValuePicker)");
                    this.m_logger.statusMessage(String.valueOf(this.statusMessagePrefix()) + "WARNING: Class value to consider as positive has not been set.");
                }
                return dataSet;
            }
            if (this.m_classValue == null) {
                return dataSet;
            }
            classAtt = dataSet.classAttribute();
            classValueIndex = -1;
            if (this.m_classValue.startsWith("/") && this.m_classValue.length() > 1) {
                remainder = this.m_classValue.substring(1);
                if ((remainder = remainder.trim()).equalsIgnoreCase("first")) {
                    classValueIndex = 0;
                } else if (remainder.equalsIgnoreCase("last")) {
                    classValueIndex = classAtt.numValues() - 1;
                } else {
                    try {
                        classValueIndex = Integer.parseInt(remainder);
                        if (--classValueIndex >= 0 && classValueIndex <= classAtt.numValues() - 1 || this.m_logger == null) ** GOTO lbl42
                        this.m_logger.logMessage("[ClassValuePicker] " + this.statusMessagePrefix() + " Class value index is out of range!" + " (ClassValuePicker)");
                        this.m_logger.statusMessage(String.valueOf(this.statusMessagePrefix()) + "ERROR: Class value index is out of range!.");
                    }
                    catch (NumberFormatException n) {
                        if (this.m_logger == null) ** GOTO lbl42
                        this.m_logger.logMessage("[ClassValuePicker] " + this.statusMessagePrefix() + " Unable to parse supplied class value index as an integer" + " (ClassValuePicker)");
                        this.m_logger.statusMessage(String.valueOf(this.statusMessagePrefix()) + "WARNING: Unable to parse supplied class value index " + "as an integer.");
                        return dataSet;
                    }
                }
            } else {
                classValueIndex = classAtt.indexOfValue(this.m_classValue.trim());
            }
lbl42:
            // 6 sources

            if (classValueIndex < 0) {
                return null;
            }
            if (classValueIndex != 0) {
                try {
                    sv = new SwapValues();
                    sv.setAttributeIndex("" + (dataSet.classIndex() + 1));
                    sv.setFirstValueIndex("first");
                    sv.setSecondValueIndex("" + (classValueIndex + 1));
                    sv.setInputFormat(dataSet);
                    newDataSet = Filter.useFilter(dataSet, sv);
                    newDataSet.setRelationName(dataSet.relationName());
                    return newDataSet;
                }
                catch (Exception ex) {
                    if (this.m_logger == null) break block20;
                    this.m_logger.logMessage("[ClassValuePicker] " + this.statusMessagePrefix() + " Unable to swap class attibute values.");
                    this.m_logger.statusMessage(String.valueOf(this.statusMessagePrefix()) + "ERROR: (See log for details)");
                    return null;
                }
            }
        }
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDataListeners(DataSetEvent tse) {
        Vector l;
        ClassValuePicker classValuePicker = this;
        synchronized (classValuePicker) {
            l = (Vector)this.m_dataListeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                System.err.println("Notifying data listeners (ClassValuePicker)");
                ((DataSourceListener)l.elementAt(i)).acceptDataSet(tse);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDataFormatListeners() {
        Vector l;
        ClassValuePicker classValuePicker = this;
        synchronized (classValuePicker) {
            l = (Vector)this.m_dataFormatListeners.clone();
        }
        if (l.size() > 0) {
            DataSetEvent dse = new DataSetEvent(this, this.m_connectedFormat);
            int i = 0;
            while (i < l.size()) {
                ((DataFormatListener)l.elementAt(i)).newDataFormat(dse);
                ++i;
            }
        }
    }

    public synchronized void addDataSourceListener(DataSourceListener tsl) {
        this.m_dataListeners.addElement(tsl);
    }

    public synchronized void removeDataSourceListener(DataSourceListener tsl) {
        this.m_dataListeners.removeElement(tsl);
    }

    public synchronized void addDataFormatListener(DataFormatListener dfl) {
        this.m_dataFormatListeners.addElement(dfl);
    }

    public synchronized void removeDataFormatListener(DataFormatListener dfl) {
        this.m_dataFormatListeners.removeElement(dfl);
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/ClassValuePicker.gif", "weka/gui/beans/icons/ClassValuePicker_animated.gif");
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        return eventName.compareTo("dataSet") != 0 || this.m_dataProvider == null;
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public synchronized void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName) && eventName.compareTo("dataSet") == 0) {
            this.m_dataProvider = source;
        }
        this.m_connectedFormat = null;
    }

    @Override
    public synchronized void disconnectionNotification(String eventName, Object source) {
        if (eventName.compareTo("dataSet") == 0 && this.m_dataProvider == source) {
            this.m_dataProvider = null;
        }
        this.m_connectedFormat = null;
    }

    @Override
    public void setLog(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (eventName.compareTo("dataSet") != 0) {
            return false;
        }
        if (eventName.compareTo("dataSet") == 0) {
            if (this.m_dataProvider == null) {
                this.m_connectedFormat = null;
                this.notifyDataFormatListeners();
                return false;
            }
            if (this.m_dataProvider instanceof EventConstraints && !((EventConstraints)this.m_dataProvider).eventGeneratable("dataSet")) {
                this.m_connectedFormat = null;
                this.notifyDataFormatListeners();
                return false;
            }
        }
        return true;
    }

    private String statusMessagePrefix() {
        return String.valueOf(this.getCustomName()) + "$" + this.hashCode() + "|";
    }
}

