/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.execute.context;

import java.util.Stack;
import org.eclipse.epsilon.egl.execute.context.EglFrameStackManager;
import org.eclipse.epsilon.egl.execute.context.ExecutableTemplateSpecification;

public class EglExecutionManager {
    private final EglFrameStackManager frameStackManager;
    private final ExecutableTemplateSpecificationStack specs = new ExecutableTemplateSpecificationStack();

    public EglExecutionManager(EglFrameStackManager frameStackManager) {
        this.frameStackManager = frameStackManager;
    }

    public void prepareFor(ExecutableTemplateSpecification spec) {
        this.specs.push(spec);
        this.frameStackManager.prepareFrameStackFor(spec);
    }

    public void restore() {
        this.frameStackManager.restoreFrameStackToPreviousState();
        this.specs.pop();
    }

    public ExecutableTemplateSpecification getCurrent() {
        return this.specs.top();
    }

    public boolean hasParent() {
        return this.specs.size() > 1;
    }

    public ExecutableTemplateSpecification getParent() {
        return this.specs.second();
    }

    public ExecutableTemplateSpecification getBase() {
        return this.specs.bottom();
    }

    private static class ExecutableTemplateSpecificationStack {
        private final Stack<ExecutableTemplateSpecification> specs = new Stack();
        private ExecutableTemplateSpecification firstSpec;

        private ExecutableTemplateSpecificationStack() {
        }

        public void push(ExecutableTemplateSpecification template) {
            this.linkToPrevious(template);
            this.specs.push(template);
        }

        private void linkToPrevious(ExecutableTemplateSpecification template) {
            if (this.firstSpec == null) {
                this.firstSpec = template;
            }
            if (!this.specs.isEmpty()) {
                this.specs.peek().addAsChild(template);
            }
        }

        public void pop() {
            this.specs.pop();
        }

        public ExecutableTemplateSpecification top() {
            return this.specs.isEmpty() ? null : this.specs.peek();
        }

        public ExecutableTemplateSpecification second() {
            return (ExecutableTemplateSpecification)this.specs.elementAt(this.specs.size() - 2);
        }

        public ExecutableTemplateSpecification bottom() {
            return this.firstSpec;
        }

        public int size() {
            return this.specs.size();
        }
    }
}

