/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.parse;

import org.antlr.runtime.CommonToken;

public class EglToken
extends CommonToken {
    private static final long serialVersionUID = -1317153822962960518L;
    private TokenType type;
    private String text;
    private int line;

    public EglToken(TokenType type, String text, int line, int col) {
        super(type.getIdentifier(), text);
        if (text == null) {
            throw new NullPointerException("text cannot be null");
        }
        this.type = type;
        this.text = text;
        this.line = line;
        this.charPositionInLine = col;
    }

    public int getColumn() {
        return this.charPositionInLine;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public int getType() {
        return this.type.getIdentifier();
    }

    public TokenType getTokenType() {
        return this.type;
    }

    public void setColumn(int column) {
        this.charPositionInLine = column;
    }

    @Override
    public void setLine(int line) {
        this.line = line;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void setType(int type) {
        this.type = TokenType.typeOf(type);
    }

    public void setTokenType(TokenType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof EglToken)) {
            return false;
        }
        EglToken that = (EglToken)o;
        return this.type.equals((Object)that.type) && this.getText().equals(that.getText()) && this.getLine() == that.getLine() && this.getColumn() == that.getColumn();
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.type.hashCode();
        result = 37 * result + this.getText().hashCode();
        result = 37 * result + this.getLine();
        result = 37 * result + this.getColumn();
        return result;
    }

    @Override
    public String toString() {
        return (Object)((Object)this.type) + " " + this.getText() + ", line " + this.getLine() + " col " + this.getColumn();
    }

    public static enum TokenType {
        PROGRAM,
        PLAIN_TEXT,
        NEW_LINE,
        START_TAG,
        START_OUTPUT_TAG,
        END_TAG,
        START_COMMENT_TAG,
        START_MARKER_TAG,
        END_COMMENT_TAG,
        EOF;

        private final int identifier = this.ordinal() + 4;

        public int getIdentifier() {
            return this.identifier;
        }

        public static TokenType typeOf(int identifier) {
            TokenType[] tokenTypeArray = TokenType.values();
            int n = tokenTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TokenType type = tokenTypeArray[n2];
                if (type.identifier == identifier) {
                    return type;
                }
                ++n2;
            }
            throw new IllegalArgumentException(String.valueOf(identifier) + " is not the identifier of any TokenType");
        }
    }
}

