/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.xmi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import org.eclipse.epsilon.hutn.xmi.HutnXmiBridgeException;

public class UriContentReader {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final URI uri;
    private BufferedReader reader;

    public UriContentReader(URI uri) {
        this.uri = uri;
    }

    public String readContents() throws HutnXmiBridgeException {
        try {
            this.prepareReader();
            String string = this.readContentsOfUri();
            return string;
        }
        catch (MalformedURLException e) {
            throw new HutnXmiBridgeException(e);
        }
        catch (IOException e) {
            throw new HutnXmiBridgeException(e);
        }
        finally {
            this.closeReader();
        }
    }

    private void prepareReader() throws IOException, MalformedURLException {
        this.reader = new BufferedReader(new InputStreamReader(this.uri.toURL().openStream()));
    }

    private String readContentsOfUri() throws IOException {
        StringBuilder contents = new StringBuilder();
        String line = null;
        while ((line = this.reader.readLine()) != null) {
            contents.append(line);
            contents.append(NEW_LINE);
        }
        return contents.toString();
    }

    private void closeReader() throws HutnXmiBridgeException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            throw new HutnXmiBridgeException(e);
        }
    }
}

