/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.engine.traceability.fine.internal;

import org.eclipse.epsilon.egl.EglPersistentTemplate;
import org.eclipse.epsilon.egl.engine.traceability.fine.internal.TracedPropertyAccess;
import org.eclipse.epsilon.egl.engine.traceability.fine.internal.TracedPropertyAccessLedger;
import org.eclipse.epsilon.egl.engine.traceability.fine.trace.ModelLocation;
import org.eclipse.epsilon.egl.engine.traceability.fine.trace.Region;
import org.eclipse.epsilon.egl.engine.traceability.fine.trace.TextLocation;
import org.eclipse.epsilon.egl.engine.traceability.fine.trace.Trace;
import org.eclipse.epsilon.egl.engine.traceability.fine.trace.TraceLink;
import org.eclipse.epsilon.egl.execute.control.DefaultTemplateExecutionListener;
import org.eclipse.epsilon.egl.execute.control.ITemplateExecutionListener;
import org.eclipse.epsilon.eol.execute.introspection.recording.IPropertyAccess;

public class TraceLinkCreatingTemplateExecutionListener
extends DefaultTemplateExecutionListener
implements ITemplateExecutionListener {
    private final Trace trace;
    private final TracedPropertyAccessLedger ledger;

    public TraceLinkCreatingTemplateExecutionListener(Trace trace, TracedPropertyAccessLedger ledger) {
        this.trace = trace;
        this.ledger = ledger;
    }

    @Override
    public void finishedGenerating(EglPersistentTemplate template, String path) {
        for (TracedPropertyAccess access : this.ledger.retrieve(template)) {
            this.trace.getTraceLinks().add(this.createTraceLink(path, access));
        }
    }

    private TraceLink createTraceLink(String path, TracedPropertyAccess access) {
        return new TraceLink(this.createSource(access), this.createDestination(access.getRegion(), path));
    }

    private ModelLocation createSource(IPropertyAccess access) {
        return new ModelLocation(access.getModelElement(), access.getPropertyName());
    }

    private TextLocation createDestination(Region region, String path) {
        return new TextLocation(region, path);
    }
}

