/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.models.transactions;

import org.eclipse.epsilon.eol.models.transactions.IModelTransaction;
import org.eclipse.epsilon.eol.models.transactions.IModelTransactionSupport;
import org.eclipse.epsilon.eol.models.transactions.ModelTransactionTree;

public abstract class NestedModelTransactionSupport
implements IModelTransactionSupport {
    protected ModelTransactionTree activeTransactionTree;

    @Override
    public void commitTransaction() {
        if (this.activeTransactionTree != null) {
            this.activeTransactionTree.getTransaction().commit();
            this.activeTransactionTree.getTransaction().dispose();
            this.activeTransactionTree = this.activeTransactionTree.getParent();
        }
    }

    @Override
    public void rollbackTransaction() {
        if (this.activeTransactionTree != null) {
            this.activeTransactionTree.getTransaction().rollback();
            this.activeTransactionTree.getTransaction().dispose();
            this.activeTransactionTree = this.activeTransactionTree.getParent();
        }
    }

    @Override
    public void startTransaction() {
        IModelTransaction newTransaction = this.createTransaction();
        this.activeTransactionTree = this.activeTransactionTree == null ? new ModelTransactionTree(newTransaction, null) : new ModelTransactionTree(newTransaction, this.activeTransactionTree);
        this.activeTransactionTree.getTransaction().start();
    }

    public abstract IModelTransaction createTransaction();
}

