/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.model.domain.rules;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.flock.context.MigrationStrategyCheckingContext;
import org.eclipse.epsilon.flock.execution.MigrateRuleContext;
import org.eclipse.epsilon.flock.execution.exceptions.FlockRuntimeException;
import org.eclipse.epsilon.flock.model.domain.rules.IgnoredProperties;
import org.eclipse.epsilon.flock.model.domain.rules.MigrateRule;

public class MigrateRules {
    private final List<MigrateRule> migrateRules;

    public MigrateRules(MigrateRule ... rules) {
        this.migrateRules = new LinkedList<MigrateRule>(Arrays.asList(rules));
    }

    public void add(MigrateRule rule) {
        this.migrateRules.add(rule);
    }

    public void check(MigrationStrategyCheckingContext context) {
        for (MigrateRule rule : this.migrateRules) {
            rule.check(context);
        }
    }

    public IgnoredProperties ignoredPropertiesFor(MigrateRuleContext context) throws FlockRuntimeException {
        IgnoredProperties ignored = new IgnoredProperties(new String[0]);
        for (MigrateRule rule : this.migrateRules) {
            rule.gatherIgnoredPropertiesFor(context, ignored);
        }
        return ignored;
    }

    public void applyTo(MigrateRuleContext context) throws FlockRuntimeException {
        for (MigrateRule rule : this.migrateRules) {
            rule.applyTo(context);
        }
    }
}

