/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.unparser.internal;

import org.eclipse.epsilon.hutn.model.hutn.NsUri;
import org.eclipse.epsilon.hutn.model.hutn.PackageObject;
import org.eclipse.epsilon.hutn.model.hutn.Spec;
import org.eclipse.epsilon.hutn.unparser.internal.PackageObjectUnparser;
import org.eclipse.epsilon.hutn.unparser.internal.Unparser;

public class SpecUnparser
extends Unparser {
    private final Spec spec;

    public SpecUnparser(Spec spec) {
        this.spec = spec;
    }

    @Override
    protected void doUnparse() {
        this.appendHeader();
        this.appendNewLine();
        this.unparsePackageObjects();
    }

    private void appendHeader() {
        if (!this.spec.getNsUris().isEmpty()) {
            this.builder.append("@Spec {");
            this.unparseNsUris();
            this.builder.append("}");
            this.appendNewLine();
        }
    }

    private void unparseNsUris() {
        for (NsUri nsUri : this.spec.getNsUris()) {
            this.unparseNsUri(nsUri);
        }
    }

    private void unparseNsUri(NsUri nsUri) {
        this.builder.append("metamodel");
        this.appendSpace();
        this.appendStringValue(nsUri.getValue());
        this.appendSpace();
        this.builder.append('{');
        this.builder.append("nsUri: ");
        this.appendStringValue(nsUri.getValue());
        this.appendNewLine();
        this.builder.append('}');
    }

    private void unparsePackageObjects() {
        for (PackageObject po : this.spec.getObjects()) {
            this.unparsePackageObject(po);
        }
    }

    private void unparsePackageObject(PackageObject po) {
        new PackageObjectUnparser(po, this.builder).unparse();
        this.appendNewLine();
    }
}

