/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.DistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.NeighborPredicate;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="M. Ester, H.-P. Kriegel, J. Sander, X. Xu", title="A Density-Based Algorithm for Discovering Clusters in Large Spatial Databases with Noise", booktitle="Proc. 2nd Int. Conf. on Knowledge Discovery and Data Mining (KDD '96), Portland, OR, 1996", url="http://www.aaai.org/Papers/KDD/1996/KDD96-037")
public class EpsilonNeighborPredicate<O>
implements NeighborPredicate {
    protected double epsilon;
    protected DistanceFunction<? super O> distFunc;

    public EpsilonNeighborPredicate(double d, DistanceFunction<? super O> distanceFunction) {
        this.epsilon = d;
        this.distFunc = distanceFunction;
    }

    @Override
    public <T> NeighborPredicate.Instance<T> instantiate(Database database, SimpleTypeInformation<?> simpleTypeInformation) {
        DistanceQuery<O> distanceQuery = QueryUtil.getDistanceQuery(database, this.distFunc, new Object[0]);
        RangeQuery<? super O> rangeQuery = database.getRangeQuery(distanceQuery, new Object[0]);
        return new Instance(this.epsilon, rangeQuery, distanceQuery.getRelation().getDBIDs());
    }

    @Override
    public SimpleTypeInformation<?>[] getOutputType() {
        return new SimpleTypeInformation[]{TypeUtil.DBIDS, TypeUtil.NEIGHBORLIST};
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return this.distFunc.getInputTypeRestriction();
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        protected double epsilon;
        protected DistanceFunction<O> distfun = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(DistanceBasedAlgorithm.DISTANCE_FUNCTION_ID, (Class<?>)DistanceFunction.class, EuclideanDistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distfun = (DistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(doubleParameter = (DoubleParameter)new DoubleParameter(DBSCAN.Parameterizer.EPSILON_ID).addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.epsilon = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected EpsilonNeighborPredicate<O> makeInstance() {
            return new EpsilonNeighborPredicate<O>(this.epsilon, this.distfun);
        }
    }

    public static class Instance
    implements NeighborPredicate.Instance<DoubleDBIDList> {
        protected double epsilon;
        protected RangeQuery<?> rq;
        protected DBIDs ids;

        public Instance(double d, RangeQuery<?> rangeQuery, DBIDs dBIDs) {
            this.epsilon = d;
            this.rq = rangeQuery;
            this.ids = dBIDs;
        }

        @Override
        public DBIDs getIDs() {
            return this.ids;
        }

        @Override
        public DoubleDBIDList getNeighbors(DBIDRef dBIDRef) {
            return this.rq.getRangeForDBID(dBIDRef, this.epsilon);
        }

        @Override
        public DBIDIter iterDBIDs(DoubleDBIDList doubleDBIDList) {
            return doubleDBIDList.iter();
        }
    }
}

