/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="SLINK: Single Link Clustering")
@Description(value="Hierarchical clustering algorithm based on single-link connectivity.")
@Reference(authors="R. Sibson", title="SLINK: An optimally efficient algorithm for the single-link cluster method", booktitle="The Computer Journal 16 (1973), No. 1, p. 30-34.", url="http://dx.doi.org/10.1093/comjnl/16.1.30")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.SLINK", "clustering.SLINK", "single-link", "single-linkage"})
public class SLINK<O>
extends AbstractDistanceBasedAlgorithm<O, PointerHierarchyRepresentationResult>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(SLINK.class);

    public SLINK(DistanceFunction<? super O> distanceFunction) {
        super(distanceFunction);
    }

    public PointerHierarchyRepresentationResult run(Database database, Relation<O> relation) {
        DBIDs dBIDs = relation.getDBIDs();
        WritableDBIDDataStore writableDBIDDataStore = DataStoreUtil.makeDBIDStorage(dBIDs, 6);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 6, Double.POSITIVE_INFINITY);
        WritableDoubleDataStore writableDoubleDataStore2 = DataStoreUtil.makeDoubleStorage(dBIDs, 3);
        Logging logging = this.getLogger();
        FiniteProgress finiteProgress = logging.isVerbose() ? new FiniteProgress("Running SLINK", dBIDs.size(), logging) : null;
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(dBIDs);
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        DBIDArrayIter dBIDArrayIter2 = arrayDBIDs.iter();
        while (dBIDArrayIter.valid()) {
            writableDBIDDataStore.put((DBIDRef)dBIDArrayIter, dBIDArrayIter);
            dBIDArrayIter.advance();
        }
        logging.incrementProcessed(finiteProgress);
        if (this.getDistanceFunction() instanceof PrimitiveDistanceFunction) {
            PrimitiveDistanceFunction primitiveDistanceFunction = (PrimitiveDistanceFunction)this.getDistanceFunction();
            dBIDArrayIter.seek(1);
            while (dBIDArrayIter.valid()) {
                this.step2primitive(dBIDArrayIter, dBIDArrayIter2, dBIDArrayIter.getOffset(), relation, primitiveDistanceFunction, writableDoubleDataStore2);
                this.process(dBIDArrayIter, arrayDBIDs, dBIDArrayIter2, dBIDArrayIter.getOffset(), writableDBIDDataStore, writableDoubleDataStore, writableDoubleDataStore2);
                logging.incrementProcessed(finiteProgress);
                dBIDArrayIter.advance();
            }
        } else {
            DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
            dBIDArrayIter.seek(1);
            while (dBIDArrayIter.valid()) {
                this.step2(dBIDArrayIter, dBIDArrayIter2, dBIDArrayIter.getOffset(), distanceQuery, writableDoubleDataStore2);
                this.process(dBIDArrayIter, arrayDBIDs, dBIDArrayIter2, dBIDArrayIter.getOffset(), writableDBIDDataStore, writableDoubleDataStore, writableDoubleDataStore2);
                logging.incrementProcessed(finiteProgress);
                dBIDArrayIter.advance();
            }
        }
        logging.ensureCompleted(finiteProgress);
        writableDoubleDataStore2.destroy();
        writableDoubleDataStore2 = null;
        return new PointerHierarchyRepresentationResult(dBIDs, writableDBIDDataStore, writableDoubleDataStore);
    }

    private void step2(DBIDRef dBIDRef, DBIDArrayIter dBIDArrayIter, int n, DistanceQuery<? super O> distanceQuery, WritableDoubleDataStore writableDoubleDataStore) {
        dBIDArrayIter.seek(0);
        while (dBIDArrayIter.getOffset() < n) {
            writableDoubleDataStore.putDouble(dBIDArrayIter, distanceQuery.distance((DBIDRef)dBIDArrayIter, dBIDRef));
            dBIDArrayIter.advance();
        }
    }

    private void step2primitive(DBIDRef dBIDRef, DBIDArrayIter dBIDArrayIter, int n, Relation<? extends O> relation, PrimitiveDistanceFunction<? super O> primitiveDistanceFunction, WritableDoubleDataStore writableDoubleDataStore) {
        O o = relation.get(dBIDRef);
        dBIDArrayIter.seek(0);
        while (dBIDArrayIter.getOffset() < n) {
            writableDoubleDataStore.putDouble(dBIDArrayIter, primitiveDistanceFunction.distance(relation.get(dBIDArrayIter), o));
            dBIDArrayIter.advance();
        }
    }

    protected void process(DBIDRef dBIDRef, ArrayDBIDs arrayDBIDs, DBIDArrayIter dBIDArrayIter, int n, WritableDBIDDataStore writableDBIDDataStore, WritableDoubleDataStore writableDoubleDataStore, WritableDoubleDataStore writableDoubleDataStore2) {
        this.slinkstep3(dBIDRef, dBIDArrayIter, n, writableDBIDDataStore, writableDoubleDataStore, writableDoubleDataStore2);
        this.slinkstep4(dBIDRef, dBIDArrayIter, n, writableDBIDDataStore, writableDoubleDataStore);
    }

    private void slinkstep3(DBIDRef dBIDRef, DBIDArrayIter dBIDArrayIter, int n, WritableDBIDDataStore writableDBIDDataStore, WritableDoubleDataStore writableDoubleDataStore, WritableDoubleDataStore writableDoubleDataStore2) {
        DBIDVar dBIDVar = DBIDUtil.newVar();
        dBIDArrayIter.seek(0);
        while (dBIDArrayIter.getOffset() < n) {
            double d = writableDoubleDataStore.doubleValue(dBIDArrayIter);
            double d2 = writableDoubleDataStore2.doubleValue(dBIDArrayIter);
            dBIDVar.from(writableDBIDDataStore, dBIDArrayIter);
            double d3 = writableDoubleDataStore2.doubleValue(dBIDVar);
            if (d >= d2) {
                if (d < d3) {
                    writableDoubleDataStore2.putDouble(dBIDVar, d);
                }
                writableDoubleDataStore.putDouble(dBIDArrayIter, d2);
                writableDBIDDataStore.put((DBIDRef)dBIDArrayIter, dBIDRef);
            } else if (d2 < d3) {
                writableDoubleDataStore2.putDouble(dBIDVar, d2);
            }
            dBIDArrayIter.advance();
        }
    }

    private void slinkstep4(DBIDRef dBIDRef, DBIDArrayIter dBIDArrayIter, int n, WritableDBIDDataStore writableDBIDDataStore, WritableDoubleDataStore writableDoubleDataStore) {
        DBIDVar dBIDVar = DBIDUtil.newVar();
        dBIDArrayIter.seek(0);
        while (dBIDArrayIter.getOffset() < n) {
            double d = writableDoubleDataStore.doubleValue(dBIDArrayIter);
            dBIDVar.from(writableDBIDDataStore, dBIDArrayIter);
            double d2 = writableDoubleDataStore.doubleValue(dBIDVar);
            if (d >= d2) {
                writableDBIDDataStore.put((DBIDRef)dBIDArrayIter, dBIDRef);
            }
            dBIDArrayIter.advance();
        }
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        @Override
        protected SLINK<O> makeInstance() {
            return new SLINK(this.distanceFunction);
        }
    }
}

