/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.extraction;

import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerDensityHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.DendrogramModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.workflow.AlgorithmStep;
import java.util.ArrayList;
import java.util.Collection;

@Reference(authors="R. J. G. B. Campello, D. Moulavi, and J. Sander", title="Density-Based Clustering Based on Hierarchical Density Estimates", booktitle="Pacific-Asia Conference on Advances in Knowledge Discovery and Data Mining, PAKDD", url="http://dx.doi.org/10.1007/978-3-642-37456-2_14")
public class HDBSCANHierarchyExtraction
implements ClusteringAlgorithm<Clustering<DendrogramModel>> {
    private static final Logging LOG = Logging.getLogger(HDBSCANHierarchyExtraction.class);
    private int minClSize = 1;
    private HierarchicalClusteringAlgorithm algorithm;
    private boolean hierarchical = true;

    public HDBSCANHierarchyExtraction(HierarchicalClusteringAlgorithm hierarchicalClusteringAlgorithm, int n, boolean bl) {
        this.algorithm = hierarchicalClusteringAlgorithm;
        this.minClSize = n;
        this.hierarchical = bl;
    }

    @Override
    public Clustering<DendrogramModel> run(Database database) {
        PointerHierarchyRepresentationResult pointerHierarchyRepresentationResult = this.algorithm.run(database);
        DBIDs dBIDs = pointerHierarchyRepresentationResult.getDBIDs();
        DBIDDataStore dBIDDataStore = pointerHierarchyRepresentationResult.getParentStore();
        DoubleDataStore doubleDataStore = pointerHierarchyRepresentationResult.getParentDistanceStore();
        DoubleDataStore doubleDataStore2 = null;
        if (pointerHierarchyRepresentationResult instanceof PointerDensityHierarchyRepresentationResult) {
            doubleDataStore2 = ((PointerDensityHierarchyRepresentationResult)pointerHierarchyRepresentationResult).getCoreDistanceStore();
        }
        Clustering<DendrogramModel> clustering = this.extractClusters(dBIDs, dBIDDataStore, doubleDataStore, doubleDataStore2);
        clustering.addChildResult(pointerHierarchyRepresentationResult);
        return clustering;
    }

    public Clustering<DendrogramModel> extractClusters(DBIDs dBIDs, DBIDDataStore dBIDDataStore, DoubleDataStore doubleDataStore, DoubleDataStore doubleDataStore2) {
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Extracting clusters", dBIDs.size(), LOG) : null;
        ArrayDBIDs arrayDBIDs = PointerHierarchyRepresentationResult.topologicalSort(dBIDs, dBIDDataStore, doubleDataStore);
        WritableDataStore<TempCluster> writableDataStore = DataStoreUtil.makeStorage(dBIDs, 1, TempCluster.class);
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
        ArrayList<TempCluster> arrayList = new ArrayList<TempCluster>();
        DBIDVar dBIDVar = DBIDUtil.newVar();
        Object object = arrayDBIDs.iter();
        while (object.valid()) {
            double d = doubleDataStore.doubleValue((DBIDRef)object);
            double d2 = doubleDataStore2 != null ? doubleDataStore2.doubleValue((DBIDRef)object) : d;
            TempCluster tempCluster = (TempCluster)writableDataStore.get((DBIDRef)object);
            writableDataStore.put((DBIDRef)object, null);
            boolean bl = this.isSpurious(tempCluster, d2 <= d);
            dBIDDataStore.assignVar((DBIDRef)object, dBIDVar);
            if (DBIDUtil.equal((DBIDRef)object, dBIDVar) || dBIDVar.isEmpty()) {
                if (tempCluster != null) {
                    if (tempCluster.isSpurious(this.minClSize)) {
                        arrayModifiableDBIDs.addDBIDs(tempCluster.members);
                    } else {
                        arrayList.add(tempCluster);
                    }
                    writableDataStore.put((DBIDRef)object, null);
                } else if (bl) {
                    arrayModifiableDBIDs.add((DBIDRef)object);
                } else {
                    arrayList.add(new TempCluster(d, (DBIDRef)object));
                }
                LOG.incrementProcessed(finiteProgress);
            } else {
                TempCluster tempCluster2;
                double d3;
                TempCluster tempCluster3 = (TempCluster)writableDataStore.get(dBIDVar);
                boolean bl2 = this.isSpurious(tempCluster3, (d3 = doubleDataStore2 != null ? doubleDataStore2.doubleValue(dBIDVar) : d) <= d);
                if (!bl2 && !bl) {
                    tempCluster = tempCluster != null ? tempCluster : new TempCluster(d2, (DBIDRef)object);
                    tempCluster3 = tempCluster3 != null ? tempCluster3 : new TempCluster(d3, dBIDVar);
                    tempCluster2 = new TempCluster(d, tempCluster3, tempCluster);
                } else {
                    tempCluster2 = !bl2 && tempCluster3 != null ? tempCluster3.grow(d, tempCluster, (DBIDRef)object) : (!bl && tempCluster != null ? tempCluster.grow(d, tempCluster3, dBIDVar) : (tempCluster3 != null ? tempCluster3.grow(d, tempCluster, (DBIDRef)object).resetAggregate() : (tempCluster != null ? tempCluster.grow(d, tempCluster3, dBIDVar).resetAggregate() : new TempCluster(d, (DBIDRef)object, dBIDVar))));
                }
                assert (tempCluster2 != null);
                writableDataStore.put(dBIDVar, tempCluster2);
                LOG.incrementProcessed(finiteProgress);
            }
            object.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        object = new Clustering("Hierarchical Clustering", "hierarchical-clustering");
        Cluster<DendrogramModel> cluster = null;
        if (arrayModifiableDBIDs.size() > 0) {
            cluster = new Cluster<DendrogramModel>("Noise", arrayModifiableDBIDs, true, new DendrogramModel(Double.POSITIVE_INFINITY));
            ((Clustering)object).addToplevelCluster(cluster);
        }
        for (TempCluster tempCluster : arrayList) {
            tempCluster.finalizeCluster((Clustering)object, cluster, false, this.hierarchical);
        }
        return object;
    }

    private boolean isSpurious(TempCluster tempCluster, boolean bl) {
        return tempCluster != null ? tempCluster.isSpurious(this.minClSize) : this.minClSize > 1 || !bl;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return this.algorithm.getInputTypeRestriction();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MINCLUSTERSIZE_ID = new OptionID("hdbscan.minclsize", "The minimum cluster size.");
        public static final OptionID HIERARCHICAL_ID = new OptionID("hdbscan.hierarchical", "Produce a hierarchical output.");
        int minClSize = 1;
        HierarchicalClusteringAlgorithm algorithm;
        boolean hierarchical = true;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            IntParameter intParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(AlgorithmStep.Parameterizer.ALGORITHM_ID, HierarchicalClusteringAlgorithm.class);
            if (parameterization.grab(objectParameter)) {
                this.algorithm = (HierarchicalClusteringAlgorithm)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(intParameter = (IntParameter)new IntParameter(MINCLUSTERSIZE_ID, 1).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.minClSize = intParameter.intValue();
            }
            if (parameterization.grab(flag = new Flag(HIERARCHICAL_ID))) {
                this.hierarchical = flag.isTrue();
            }
        }

        @Override
        protected HDBSCANHierarchyExtraction makeInstance() {
            return new HDBSCANHierarchyExtraction(this.algorithm, this.minClSize, this.hierarchical);
        }
    }

    protected static class TempCluster {
        protected ModifiableDBIDs members = DBIDUtil.newArray();
        protected double dist = 0.0;
        protected double aggregate = 0.0;
        protected int childrenTotal = 0;
        protected Collection<TempCluster> children = new ArrayList<TempCluster>();

        public TempCluster(double d) {
            this.dist = d;
        }

        public TempCluster(double d, DBIDRef dBIDRef) {
            this.dist = d;
            this.members.add(dBIDRef);
            this.aggregate = 1.0 / d;
        }

        public TempCluster(double d, DBIDRef dBIDRef, DBIDRef dBIDRef2) {
            this.dist = d;
            this.members.add(dBIDRef);
            this.members.add(dBIDRef2);
            this.aggregate = 2.0 / d;
        }

        public TempCluster(double d, TempCluster tempCluster, TempCluster tempCluster2) {
            this.dist = d;
            this.children.add(tempCluster);
            this.children.add(tempCluster2);
            this.childrenTotal = tempCluster.totalElements() + tempCluster2.totalElements();
            this.aggregate = (double)this.childrenTotal / d;
        }

        public TempCluster grow(double d, TempCluster tempCluster, DBIDRef dBIDRef) {
            this.dist = d;
            if (tempCluster == null) {
                this.members.add(dBIDRef);
                this.aggregate += 1.0 / d;
            } else {
                assert (tempCluster.children.size() == 0);
                this.members.addDBIDs(tempCluster.members);
                this.aggregate += (double)tempCluster.members.size() / d;
                tempCluster.members = null;
                tempCluster.children = null;
            }
            return this;
        }

        public TempCluster grow(double d, DBIDRef dBIDRef) {
            this.dist = d;
            this.members.add(dBIDRef);
            this.aggregate += 1.0 / d;
            return this;
        }

        public TempCluster resetAggregate() {
            this.aggregate = (double)this.totalElements() / this.dist;
            return this;
        }

        public int totalElements() {
            return this.childrenTotal + this.members.size();
        }

        public double excessOfMass() {
            return this.aggregate - (double)this.totalElements() / this.dist;
        }

        public double totalStability() {
            double d = this.excessOfMass();
            double d2 = 0.0;
            for (TempCluster tempCluster : this.children) {
                d2 += Math.abs(tempCluster.totalStability());
            }
            return d > d2 ? d : -d2;
        }

        public boolean isSpurious(int n) {
            return this.children.size() == 0 && this.members.size() < n;
        }

        private void finalizeCluster(Clustering<DendrogramModel> clustering, Cluster<DendrogramModel> cluster, boolean bl, boolean bl2) {
            String string = "C_" + FormatUtil.NF6.format(this.dist);
            Cluster<DendrogramModel> cluster2 = new Cluster<DendrogramModel>(string, (DBIDs)this.members, new DendrogramModel(this.dist));
            if (bl2 && cluster != null) {
                clustering.addChildCluster(cluster, cluster2);
            } else {
                clustering.addToplevelCluster(cluster2);
            }
            this.collectChildren(clustering, this, cluster2, bl, bl2);
            this.members = null;
            this.children = null;
        }

        private void collectChildren(Clustering<DendrogramModel> clustering, TempCluster tempCluster, Cluster<DendrogramModel> cluster, boolean bl, boolean bl2) {
            for (TempCluster tempCluster2 : tempCluster.children) {
                if (bl || tempCluster2.totalStability() < 0.0) {
                    this.members.addDBIDs(tempCluster2.members);
                    this.collectChildren(clustering, tempCluster2, cluster, bl, bl2);
                    continue;
                }
                tempCluster2.finalizeCluster(clustering, cluster, true, bl2);
            }
        }
    }
}

