/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.FarthestPointsInitialMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.PAMInitialMeans;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.MedoidModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.distancematrix.PrecomputedDistanceMatrix;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.List;

public class KMedoidsEM<V>
extends AbstractDistanceBasedAlgorithm<V, Clustering<MedoidModel>>
implements ClusteringAlgorithm<Clustering<MedoidModel>> {
    private static final Logging LOG = Logging.getLogger(KMedoidsEM.class);
    private static final String KEY = KMedoidsEM.class.getName();
    protected int k;
    protected int maxiter;
    protected KMedoidsInitialization<V> initializer;

    public KMedoidsEM(DistanceFunction<? super V> distanceFunction, int n, int n2, KMedoidsInitialization<V> kMedoidsInitialization) {
        super(distanceFunction);
        this.k = n;
        this.maxiter = n2;
        this.initializer = kMedoidsInitialization;
    }

    public Clustering<MedoidModel> run(Database database, Relation<V> relation) {
        Object object;
        Object object2;
        if (relation.size() <= 0) {
            return new Clustering<MedoidModel>("k-Medoids Clustering", "kmedoids-clustering");
        }
        DistanceQuery<Object> distanceQuery = null;
        if (this.initializer instanceof PAMInitialMeans && (distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), "optimized")) == null) {
            LOG.verbose("Adding a distance matrix index to accelerate PAM.");
            object2 = new PrecomputedDistanceMatrix<V>(relation, this.getDistanceFunction());
            ((PrecomputedDistanceMatrix)object2).initialize();
            distanceQuery = ((PrecomputedDistanceMatrix)object2).getDistanceQuery(this.getDistanceFunction(), new Object[0]);
        }
        if (distanceQuery == null) {
            distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        }
        if (LOG.isStatistics()) {
            LOG.statistics(new StringStatistic(KEY + ".initialization", this.initializer.toString()));
        }
        object2 = DBIDUtil.newArray(this.initializer.chooseInitialMedoids(this.k, relation.getDBIDs(), distanceQuery));
        ArrayList<HashSetModifiableDBIDs> arrayList = new ArrayList<HashSetModifiableDBIDs>();
        for (int i = 0; i < this.k; ++i) {
            arrayList.add(DBIDUtil.newHashSet(relation.size() / this.k));
        }
        Mean[] meanArray = Mean.newArray(this.k);
        this.assignToNearestCluster((ArrayDBIDs)object2, meanArray, arrayList, distanceQuery);
        IndefiniteProgress indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("K-Medoids iteration", LOG) : null;
        int n = 0;
        boolean bl = true;
        while (bl) {
            LOG.incrementProcessed(indefiniteProgress);
            bl = false;
            int n2 = 0;
            object = object2.iter();
            while (object.valid()) {
                DBID dBID = null;
                Mean mean = meanArray[n2];
                DBIDMIter dBIDMIter = ((ModifiableDBIDs)arrayList.get(n2)).iter();
                while (dBIDMIter.valid()) {
                    if (!DBIDUtil.equal((DBIDRef)object, dBIDMIter)) {
                        Mean mean2 = new Mean();
                        DBIDMIter dBIDMIter2 = ((ModifiableDBIDs)arrayList.get(n2)).iter();
                        while (dBIDMIter2.valid()) {
                            mean2.put(distanceQuery.distance((DBIDRef)dBIDMIter, (DBIDRef)dBIDMIter2));
                            dBIDMIter2.advance();
                        }
                        if (mean2.getMean() < mean.getMean()) {
                            dBID = DBIDUtil.deref(dBIDMIter);
                            mean = mean2;
                        }
                    }
                    dBIDMIter.advance();
                }
                if (dBID != null && !DBIDUtil.equal((DBIDRef)object, dBID)) {
                    bl = true;
                    object2.set(n2, dBID);
                    meanArray[n2] = mean;
                }
                object.advance();
                ++n2;
            }
            if (bl) {
                this.assignToNearestCluster((ArrayDBIDs)object2, meanArray, arrayList, distanceQuery);
            }
            ++n;
        }
        LOG.setCompleted(indefiniteProgress);
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(KEY + ".iterations", n));
        }
        Clustering<MedoidModel> clustering = new Clustering<MedoidModel>("k-Medoids Clustering", "kmedoids-clustering");
        DBIDArrayMIter dBIDArrayMIter = object2.iter();
        while (dBIDArrayMIter.valid()) {
            object = new MedoidModel(DBIDUtil.deref(dBIDArrayMIter));
            clustering.addToplevelCluster(new Cluster<Object>((DBIDs)arrayList.get(dBIDArrayMIter.getOffset()), object));
            dBIDArrayMIter.advance();
        }
        return clustering;
    }

    protected boolean assignToNearestCluster(ArrayDBIDs arrayDBIDs, Mean[] meanArray, List<? extends ModifiableDBIDs> list, DistanceQuery<V> distanceQuery) {
        boolean bl = false;
        double[] dArray = new double[this.k];
        DBIDIter dBIDIter = distanceQuery.getRelation().iterDBIDs();
        while (dBIDIter.valid()) {
            int n = 0;
            double d = Double.POSITIVE_INFINITY;
            int n2 = 0;
            DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
            while (dBIDArrayIter.valid()) {
                dArray[n2] = distanceQuery.distance((DBIDRef)dBIDIter, (DBIDRef)dBIDArrayIter);
                if (dArray[n2] < d) {
                    n = n2;
                    d = dArray[n2];
                }
                dBIDArrayIter.advance();
                ++n2;
            }
            if (list.get(n).add(dBIDIter)) {
                bl = true;
                meanArray[n].put(d);
                for (n2 = 0; n2 < this.k; ++n2) {
                    if (n2 == n || !list.get(n2).remove(dBIDIter)) continue;
                    meanArray[n].put(dArray[n2], -1.0);
                    break;
                }
            }
            dBIDIter.advance();
        }
        return bl;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<V> {
        protected int k;
        protected int maxiter;
        protected KMedoidsInitialization<V> initializer;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(KMeans.K_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = intParameter.intValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(KMeans.INIT_ID, (Class<?>)KMedoidsInitialization.class, FarthestPointsInitialMeans.class))) {
                this.initializer = (KMedoidsInitialization)objectParameter.instantiateClass(parameterization);
            }
            IntParameter intParameter2 = new IntParameter(KMeans.MAXITER_ID, 0);
            intParameter2.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (parameterization.grab(intParameter2)) {
                this.maxiter = intParameter2.intValue();
            }
        }

        @Override
        protected KMedoidsEM<V> makeInstance() {
            return new KMedoidsEM<V>(this.distanceFunction, this.k, this.maxiter, this.initializer);
        }
    }
}

