/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithmUtil;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.PAMInitialMeans;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.MedoidModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.distancematrix.PrecomputedDistanceMatrix;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Arrays;

@Title(value="Partioning Around Medoids")
@Reference(title="Clustering by means of Medoids", authors="Kaufman, L. and Rousseeuw, P.J.", booktitle="Statistical Data Analysis Based on the L1-Norm and Related Methods")
public class KMedoidsPAM<V>
extends AbstractDistanceBasedAlgorithm<V, Clustering<MedoidModel>>
implements ClusteringAlgorithm<Clustering<MedoidModel>> {
    private static final Logging LOG = Logging.getLogger(KMedoidsPAM.class);
    private static final String KEY = KMedoidsPAM.class.getName();
    protected int k;
    protected int maxiter;
    protected KMedoidsInitialization<V> initializer;

    public KMedoidsPAM(DistanceFunction<? super V> distanceFunction, int n, int n2, KMedoidsInitialization<V> kMedoidsInitialization) {
        super(distanceFunction);
        this.k = n;
        this.maxiter = n2;
        this.initializer = kMedoidsInitialization;
    }

    public Clustering<MedoidModel> run(Database database, Relation<V> relation) {
        Object object;
        if (relation.size() <= 0) {
            return new Clustering<MedoidModel>("PAM Clustering", "pam-clustering");
        }
        DistanceQuery<Object> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), "optimized");
        DBIDs dBIDs = relation.getDBIDs();
        if (distanceQuery == null && dBIDs instanceof DBIDRange) {
            LOG.verbose("Adding a distance matrix index to accelerate PAM.");
            object = new PrecomputedDistanceMatrix<V>(relation, this.getDistanceFunction());
            ((PrecomputedDistanceMatrix)object).initialize();
            distanceQuery = ((PrecomputedDistanceMatrix)object).getDistanceQuery(this.getDistanceFunction(), new Object[0]);
        }
        if (distanceQuery == null) {
            distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
            LOG.warning("PAM may be slow, because we do not have a precomputed distance matrix available.");
        }
        if (LOG.isStatistics()) {
            LOG.statistics(new StringStatistic(KEY + ".initialization", this.initializer.toString()));
        }
        if ((object = DBIDUtil.newArray(this.initializer.chooseInitialMedoids(this.k, dBIDs, distanceQuery))).size() != this.k) {
            throw new AbortException("Initializer " + this.initializer.toString() + " did not return " + this.k + " means, but " + object.size());
        }
        WritableIntegerDataStore writableIntegerDataStore = DataStoreUtil.makeIntegerStorage(dBIDs, 3, -1);
        this.runPAMOptimization(distanceQuery, dBIDs, (ArrayModifiableDBIDs)object, writableIntegerDataStore);
        ArrayModifiableDBIDs[] arrayModifiableDBIDsArray = ClusteringAlgorithmUtil.partitionsFromIntegerLabels(dBIDs, writableIntegerDataStore, this.k);
        Clustering<MedoidModel> clustering = new Clustering<MedoidModel>("PAM Clustering", "pam-clustering");
        DBIDArrayMIter dBIDArrayMIter = object.iter();
        while (dBIDArrayMIter.valid()) {
            MedoidModel medoidModel = new MedoidModel(DBIDUtil.deref(dBIDArrayMIter));
            clustering.addToplevelCluster(new Cluster<MedoidModel>((DBIDs)arrayModifiableDBIDsArray[dBIDArrayMIter.getOffset()], medoidModel));
            dBIDArrayMIter.advance();
        }
        return clustering;
    }

    protected void runPAMOptimization(DistanceQuery<V> distanceQuery, DBIDs dBIDs, ArrayModifiableDBIDs arrayModifiableDBIDs, WritableIntegerDataStore writableIntegerDataStore) {
        int n;
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 3);
        WritableDoubleDataStore writableDoubleDataStore2 = DataStoreUtil.makeDoubleStorage(dBIDs, 3);
        double d = this.assignToNearestCluster(arrayModifiableDBIDs, dBIDs, writableDoubleDataStore, writableDoubleDataStore2, writableIntegerDataStore, distanceQuery);
        if (LOG.isStatistics()) {
            LOG.statistics(new DoubleStatistic(KEY + ".iteration-" + 0 + ".cost", d));
        }
        IndefiniteProgress indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("PAM iteration", LOG) : null;
        DBIDVar dBIDVar = DBIDUtil.newVar();
        DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs.iter();
        double[] dArray = new double[this.k];
        for (n = 1; this.maxiter <= 0 || n <= this.maxiter; ++n) {
            LOG.incrementProcessed(indefiniteProgress);
            double d2 = Double.POSITIVE_INFINITY;
            int n2 = -1;
            DBIDIter dBIDIter = dBIDs.iter();
            while (dBIDIter.valid()) {
                int n3 = writableIntegerDataStore.intValue(dBIDIter);
                dBIDArrayMIter.seek(n3);
                double d3 = writableDoubleDataStore.doubleValue(dBIDIter);
                if (!DBIDUtil.equal(dBIDArrayMIter, dBIDIter) && !(d3 <= 0.0)) {
                    Arrays.fill(dArray, -d3);
                    DBIDIter dBIDIter2 = dBIDs.iter();
                    while (dBIDIter2.valid()) {
                        if (!DBIDUtil.equal(dBIDIter, dBIDIter2)) {
                            int n4 = writableIntegerDataStore.intValue(dBIDIter2);
                            double d4 = writableDoubleDataStore.doubleValue(dBIDIter2);
                            double d5 = writableDoubleDataStore2.doubleValue(dBIDIter2);
                            double d6 = distanceQuery.distance((DBIDRef)dBIDIter, (DBIDRef)dBIDIter2);
                            if (d6 < d4) {
                                for (int i = 0; i < this.k; ++i) {
                                    if (i == n4) {
                                        int n5 = i;
                                        dArray[n5] = dArray[n5] + ((d6 < d5 ? d6 : d5) - d4);
                                        continue;
                                    }
                                    int n6 = i;
                                    dArray[n6] = dArray[n6] + (d6 - d4);
                                }
                            } else if (d6 < d5) {
                                int n7 = n4;
                                dArray[n7] = dArray[n7] + (d6 - d4);
                            } else {
                                int n8 = n4;
                                dArray[n8] = dArray[n8] + (d5 - d4);
                            }
                        }
                        dBIDIter2.advance();
                    }
                    for (int i = 0; i < this.k; ++i) {
                        if (!(dArray[i] < d2)) continue;
                        d2 = dArray[i];
                        dBIDVar.set(dBIDIter);
                        n2 = i;
                    }
                }
                dBIDIter.advance();
            }
            if (d2 >= 0.0) break;
            arrayModifiableDBIDs.set(n2, dBIDVar);
            double d7 = this.assignToNearestCluster(arrayModifiableDBIDs, dBIDs, writableDoubleDataStore, writableDoubleDataStore2, writableIntegerDataStore, distanceQuery);
            if (LOG.isStatistics()) {
                LOG.statistics(new DoubleStatistic(KEY + ".iteration-" + n + ".cost", d7));
            }
            if (d7 > d) {
                if (d7 - d < 1.0E-7 * d) {
                    LOG.warning("PAM failed to converge (numerical instability?)");
                    break;
                }
                LOG.warning("PAM failed to converge: costs increased by: " + (d7 - d) + " exepected a decrease by " + d2);
                break;
            }
            d = d7;
        }
        LOG.setCompleted(indefiniteProgress);
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(KEY + ".iterations", n));
            LOG.statistics(new DoubleStatistic(KEY + ".iteration-" + n + ".cost", d));
        }
    }

    protected double assignToNearestCluster(ArrayDBIDs arrayDBIDs, DBIDs dBIDs, WritableDoubleDataStore writableDoubleDataStore, WritableDoubleDataStore writableDoubleDataStore2, WritableIntegerDataStore writableIntegerDataStore, DistanceQuery<V> distanceQuery) {
        assert (arrayDBIDs.size() == this.k);
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        double d = 0.0;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double d2 = Double.POSITIVE_INFINITY;
            double d3 = Double.POSITIVE_INFINITY;
            int n = -1;
            for (int i = 0; i < this.k; ++i) {
                double d4 = distanceQuery.distance((DBIDRef)dBIDIter, (DBIDRef)dBIDArrayIter.seek(i));
                if (d4 < d2) {
                    d3 = d2;
                    d2 = d4;
                    n = i;
                    continue;
                }
                if (!(d4 < d3)) continue;
                d3 = d4;
            }
            if (n < 0) {
                throw new AbortException("Too many infinite distances. Cannot assign objects.");
            }
            writableIntegerDataStore.put((DBIDRef)dBIDIter, n);
            writableDoubleDataStore.put((DBIDRef)dBIDIter, d2);
            writableDoubleDataStore2.put((DBIDRef)dBIDIter, d3);
            d += d2;
            dBIDIter.advance();
        }
        return d;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<V> {
        protected int k;
        protected int maxiter;
        protected KMedoidsInitialization<V> initializer;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            IntParameter intParameter;
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter2 = (IntParameter)new IntParameter(KMeans.K_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter2)) {
                this.k = intParameter2.intValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(KMeans.INIT_ID, (Class<?>)KMedoidsInitialization.class, PAMInitialMeans.class))) {
                this.initializer = (KMedoidsInitialization)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(intParameter = (IntParameter)new IntParameter(KMeans.MAXITER_ID, 0).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT))) {
                this.maxiter = intParameter.intValue();
            }
        }

        @Override
        protected KMedoidsPAM<V> makeInstance() {
            return new KMedoidsPAM<V>(this.distanceFunction, this.k, this.maxiter, this.initializer);
        }
    }
}

