/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.optics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.KNNJoin;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.OPTICSTypeAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluTreeIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.UpdatableHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import gnu.trove.set.TIntSet;
import java.util.ArrayList;
import java.util.List;

@Title(value="DeliClu: Density-Based Hierarchical Clustering")
@Description(value="Hierachical algorithm to find density-connected sets in a database based on the parameter 'minpts'.")
@Reference(authors="E. Achtert, C. B\u00f6hm, P. Kr\u00f6ger", title="DeLiClu: Boosting Robustness, Completeness, Usability, and Efficiency of Hierarchical Clustering by a Closest Pair Ranking", booktitle="Proc. 10th Pacific-Asia Conference on Knowledge Discovery and Data Mining (PAKDD 2006), Singapore, 2006", url="http://dx.doi.org/10.1007/11731139_16")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.DeLiClu"})
public class DeLiClu<NV extends NumberVector>
extends AbstractDistanceBasedAlgorithm<NV, ClusterOrder>
implements OPTICSTypeAlgorithm {
    private static final Logging LOG = Logging.getLogger(DeLiClu.class);
    private UpdatableHeap<SpatialObjectPair> heap;
    private KNNJoin<NV, DeLiCluNode, DeLiCluEntry> knnJoin;
    private int minpts;

    public DeLiClu(DistanceFunction<? super NV> distanceFunction, int n) {
        super(distanceFunction);
        this.knnJoin = new KNNJoin(distanceFunction, n);
        this.minpts = n;
    }

    public ClusterOrder run(Database database, Relation<NV> relation) {
        ArrayList<DeLiCluTreeIndex> arrayList = ResultUtil.filterResults(database.getHierarchy(), relation, DeLiCluTreeIndex.class);
        if (arrayList.size() != 1) {
            throw new AbortException("DeLiClu found " + arrayList.size() + " DeLiCluTree indexes. DeLiClu needs a special index to operate, therefore you need to add this index to your database.");
        }
        DeLiCluTreeIndex deLiCluTreeIndex = (DeLiCluTreeIndex)arrayList.iterator().next();
        if (!(this.getDistanceFunction() instanceof SpatialPrimitiveDistanceFunction)) {
            throw new IllegalArgumentException("Distance Function must be an instance of " + SpatialPrimitiveDistanceFunction.class.getName());
        }
        SpatialPrimitiveDistanceFunction spatialPrimitiveDistanceFunction = (SpatialPrimitiveDistanceFunction)this.getDistanceFunction();
        if (LOG.isVerbose()) {
            LOG.verbose("knnJoin...");
        }
        WritableDataStore<KNNList> writableDataStore = this.knnJoin.run(relation);
        DBIDs dBIDs = relation.getDBIDs();
        int n = dBIDs.size();
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("DeLiClu", n, LOG) : null;
        ClusterOrder clusterOrder = new ClusterOrder(dBIDs, "DeLiClu Clustering", "deliclu-clustering");
        this.heap = new UpdatableHeap();
        DBID dBID = DBIDUtil.deref(dBIDs.iter());
        clusterOrder.add(dBID, Double.POSITIVE_INFINITY, null);
        int n2 = 1;
        deLiCluTreeIndex.setHandled(dBID, (NumberVector)relation.get(dBID));
        SpatialDirectoryEntry spatialDirectoryEntry = (SpatialDirectoryEntry)deLiCluTreeIndex.getRootEntry();
        SpatialObjectPair spatialObjectPair = new SpatialObjectPair(0.0, spatialDirectoryEntry, spatialDirectoryEntry, true);
        this.heap.add(spatialObjectPair);
        while (n2 < n) {
            if (this.heap.isEmpty()) {
                throw new AbortException("DeLiClu heap was empty when it shouldn't have been.");
            }
            SpatialObjectPair spatialObjectPair2 = this.heap.poll();
            if (spatialObjectPair2.isExpandable) {
                this.expandNodes(deLiCluTreeIndex, spatialPrimitiveDistanceFunction, spatialObjectPair2, writableDataStore);
                continue;
            }
            LeafEntry leafEntry = (LeafEntry)((Object)spatialObjectPair2.entry1);
            LeafEntry leafEntry2 = (LeafEntry)((Object)spatialObjectPair2.entry2);
            DBID dBID2 = leafEntry.getDBID();
            IndexTreePath<DeLiCluEntry> indexTreePath = deLiCluTreeIndex.setHandled(dBID2, (NumberVector)relation.get(dBID2));
            if (indexTreePath == null) {
                throw new RuntimeException("snh: parent(" + dBID2 + ") = null!!!");
            }
            clusterOrder.add(dBID2, spatialObjectPair2.distance, leafEntry2.getDBID());
            ++n2;
            this.reinsertExpanded(spatialPrimitiveDistanceFunction, deLiCluTreeIndex, indexTreePath, writableDataStore);
            if (finiteProgress == null) continue;
            finiteProgress.setProcessed(n2, LOG);
        }
        LOG.ensureCompleted(finiteProgress);
        return clusterOrder;
    }

    private void expandNodes(DeLiCluTree deLiCluTree, SpatialPrimitiveDistanceFunction<NV> spatialPrimitiveDistanceFunction, SpatialObjectPair spatialObjectPair, DataStore<KNNList> dataStore) {
        DeLiCluNode deLiCluNode = (DeLiCluNode)deLiCluTree.getNode(((SpatialDirectoryEntry)spatialObjectPair.entry1).getPageID().intValue());
        DeLiCluNode deLiCluNode2 = (DeLiCluNode)deLiCluTree.getNode(((SpatialDirectoryEntry)spatialObjectPair.entry2).getPageID().intValue());
        if (deLiCluNode.isLeaf()) {
            this.expandLeafNodes(spatialPrimitiveDistanceFunction, deLiCluNode, deLiCluNode2, dataStore);
        } else {
            this.expandDirNodes(spatialPrimitiveDistanceFunction, deLiCluNode, deLiCluNode2);
        }
        deLiCluTree.setExpanded(spatialObjectPair.entry2, spatialObjectPair.entry1);
    }

    private void expandDirNodes(SpatialPrimitiveDistanceFunction<NV> spatialPrimitiveDistanceFunction, DeLiCluNode deLiCluNode, DeLiCluNode deLiCluNode2) {
        if (LOG.isDebuggingFinest()) {
            LOG.debugFinest("ExpandDirNodes: " + deLiCluNode.getPageID() + " + " + deLiCluNode2.getPageID());
        }
        int n = deLiCluNode.getNumEntries();
        int n2 = deLiCluNode2.getNumEntries();
        for (int i = 0; i < n; ++i) {
            DeLiCluEntry deLiCluEntry = (DeLiCluEntry)deLiCluNode.getEntry(i);
            if (!deLiCluEntry.hasUnhandled()) continue;
            for (int j = 0; j < n2; ++j) {
                DeLiCluEntry deLiCluEntry2 = (DeLiCluEntry)deLiCluNode2.getEntry(j);
                if (!deLiCluEntry2.hasHandled()) continue;
                double d = spatialPrimitiveDistanceFunction.minDist(deLiCluEntry, deLiCluEntry2);
                SpatialObjectPair spatialObjectPair = new SpatialObjectPair(d, deLiCluEntry, deLiCluEntry2, true);
                this.heap.add(spatialObjectPair);
            }
        }
    }

    private void expandLeafNodes(SpatialPrimitiveDistanceFunction<NV> spatialPrimitiveDistanceFunction, DeLiCluNode deLiCluNode, DeLiCluNode deLiCluNode2, DataStore<KNNList> dataStore) {
        if (LOG.isDebuggingFinest()) {
            LOG.debugFinest("ExpandLeafNodes: " + deLiCluNode.getPageID() + " + " + deLiCluNode2.getPageID());
        }
        int n = deLiCluNode.getNumEntries();
        int n2 = deLiCluNode2.getNumEntries();
        for (int i = 0; i < n; ++i) {
            DeLiCluEntry deLiCluEntry = (DeLiCluEntry)deLiCluNode.getEntry(i);
            if (!deLiCluEntry.hasUnhandled()) continue;
            for (int j = 0; j < n2; ++j) {
                DeLiCluEntry deLiCluEntry2 = (DeLiCluEntry)deLiCluNode2.getEntry(j);
                if (!deLiCluEntry2.hasHandled()) continue;
                double d = spatialPrimitiveDistanceFunction.minDist(deLiCluEntry, deLiCluEntry2);
                double d2 = MathUtil.max(d, dataStore.get(((LeafEntry)((Object)deLiCluEntry2)).getDBID()).getKNNDistance());
                SpatialObjectPair spatialObjectPair = new SpatialObjectPair(d2, deLiCluEntry, deLiCluEntry2, false);
                this.heap.add(spatialObjectPair);
            }
        }
    }

    private void reinsertExpanded(SpatialPrimitiveDistanceFunction<NV> spatialPrimitiveDistanceFunction, DeLiCluTree deLiCluTree, IndexTreePath<DeLiCluEntry> indexTreePath, DataStore<KNNList> dataStore) {
        Object object;
        int n = 0;
        for (object = indexTreePath; object != null; object = ((IndexTreePath)object).getParentPath()) {
            ++n;
        }
        object = new ArrayList(n - 1);
        IndexTreePath<DeLiCluEntry> indexTreePath2 = indexTreePath;
        while (indexTreePath2.getParentPath() != null) {
            ((ArrayList)object).add(indexTreePath2);
            indexTreePath2 = indexTreePath2.getParentPath();
        }
        assert (((ArrayList)object).size() == n - 1);
        DeLiCluEntry deLiCluEntry = indexTreePath2.getEntry();
        this.reinsertExpanded(spatialPrimitiveDistanceFunction, deLiCluTree, (List<IndexTreePath<DeLiCluEntry>>)object, n - 2, deLiCluEntry, dataStore);
    }

    private void reinsertExpanded(SpatialPrimitiveDistanceFunction<NV> spatialPrimitiveDistanceFunction, DeLiCluTree deLiCluTree, List<IndexTreePath<DeLiCluEntry>> list, int n, DeLiCluEntry deLiCluEntry, DataStore<KNNList> dataStore) {
        DeLiCluNode deLiCluNode = (DeLiCluNode)deLiCluTree.getNode(deLiCluEntry);
        SpatialEntry spatialEntry = list.get(n).getEntry();
        if (spatialEntry.isLeafEntry()) {
            assert (n == 0);
            for (int i = 0; i < deLiCluNode.getNumEntries(); ++i) {
                DeLiCluEntry deLiCluEntry2 = (DeLiCluEntry)deLiCluNode.getEntry(i);
                if (deLiCluEntry2.hasHandled()) continue;
                double d = spatialPrimitiveDistanceFunction.minDist(deLiCluEntry2, spatialEntry);
                double d2 = MathUtil.max(d, dataStore.get(((LeafEntry)((Object)spatialEntry)).getDBID()).getKNNDistance());
                SpatialObjectPair spatialObjectPair = new SpatialObjectPair(d2, deLiCluEntry2, spatialEntry, false);
                this.heap.add(spatialObjectPair);
            }
            return;
        }
        TIntSet tIntSet = deLiCluTree.getExpanded(spatialEntry);
        for (int i = 0; i < deLiCluNode.getNumEntries(); ++i) {
            DeLiCluDirectoryEntry deLiCluDirectoryEntry = (DeLiCluDirectoryEntry)deLiCluNode.getEntry(i);
            if (!tIntSet.contains(deLiCluDirectoryEntry.getPageID())) {
                double d = spatialPrimitiveDistanceFunction.minDist(deLiCluDirectoryEntry, spatialEntry);
                SpatialObjectPair spatialObjectPair = new SpatialObjectPair(d, deLiCluDirectoryEntry, spatialEntry, true);
                this.heap.add(spatialObjectPair);
                continue;
            }
            this.reinsertExpanded(spatialPrimitiveDistanceFunction, deLiCluTree, list, n - 1, deLiCluDirectoryEntry, dataStore);
        }
    }

    @Override
    public int getMinPts() {
        return this.minpts;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<NV extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<NV> {
        public static final OptionID MINPTS_ID = new OptionID("deliclu.minpts", "Threshold for minimum number of points within a cluster.");
        protected int minpts = 0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(MINPTS_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.minpts = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected DeLiClu<NV> makeInstance() {
            return new DeLiClu(this.distanceFunction, this.minpts);
        }
    }

    public class SpatialObjectPair
    implements Comparable<SpatialObjectPair> {
        SpatialEntry entry1;
        SpatialEntry entry2;
        boolean isExpandable;
        double distance;

        public SpatialObjectPair(double d, SpatialEntry spatialEntry, SpatialEntry spatialEntry2, boolean bl) {
            this.distance = d;
            this.entry1 = spatialEntry;
            this.entry2 = spatialEntry2;
            this.isExpandable = bl;
        }

        @Override
        public int compareTo(SpatialObjectPair spatialObjectPair) {
            return Double.compare(this.distance, spatialObjectPair.distance);
        }

        public String toString() {
            if (!this.isExpandable) {
                return this.entry1 + " - " + this.entry2;
            }
            return "n_" + this.entry1 + " - n_" + this.entry2;
        }

        public boolean equals(Object object) {
            if (!SpatialObjectPair.class.isInstance(object)) {
                return false;
            }
            SpatialObjectPair spatialObjectPair = (SpatialObjectPair)object;
            if (!this.isExpandable) {
                return this.entry1.equals(spatialObjectPair.entry1);
            }
            return this.entry1.equals(spatialObjectPair.entry1) && this.entry2.equals(spatialObjectPair.entry2);
        }

        public int hashCode() {
            if (!this.isExpandable) {
                return this.entry1.hashCode();
            }
            long l = 0L;
            l = 2654435761L * l + (long)(this.entry1 == null ? 0 : this.entry1.hashCode());
            l = 2654435761L * l + (long)(this.entry2 == null ? 0 : this.entry2.hashCode());
            return (int)l;
        }
    }
}

