/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.optics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.OPTICSHeap;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.OPTICSTypeAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.OPTICSModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.result.IterableResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.OPTICSXi"})
public class OPTICSXi
extends AbstractAlgorithm<Clustering<OPTICSModel>>
implements ClusteringAlgorithm<Clustering<OPTICSModel>> {
    private static final Logging LOG = Logging.getLogger(OPTICSXi.class);
    OPTICSTypeAlgorithm optics;
    double xi;
    boolean nocorrect;
    boolean keepsteep;

    public OPTICSXi(OPTICSTypeAlgorithm oPTICSTypeAlgorithm, double d, boolean bl, boolean bl2) {
        this.optics = oPTICSTypeAlgorithm;
        this.xi = d;
        this.nocorrect = bl;
        this.keepsteep = bl2;
    }

    public OPTICSXi(OPTICSTypeAlgorithm oPTICSTypeAlgorithm, double d) {
        this(oPTICSTypeAlgorithm, d, false, false);
    }

    public Clustering<OPTICSModel> run(Database database, Relation<?> relation) {
        ClusterOrder clusterOrder = this.optics.run(database);
        if (LOG.isVerbose()) {
            LOG.verbose("Extracting clusters with Xi: " + this.xi);
        }
        return this.extractClusters(clusterOrder, relation, 1.0 - this.xi, this.optics.getMinPts());
    }

    private Clustering<OPTICSModel> extractClusters(ClusterOrder clusterOrder, Relation<?> relation, double d, int n) {
        ArrayModifiableDBIDs arrayModifiableDBIDs = clusterOrder.ids;
        WritableDoubleDataStore writableDoubleDataStore = clusterOrder.reachability;
        DBIDArrayIter dBIDArrayIter = arrayModifiableDBIDs.iter();
        DBIDVar dBIDVar = DBIDUtil.newVar();
        double d2 = 0.0;
        ArrayList<SteepArea> arrayList = this.keepsteep ? new ArrayList<SteepArea>() : null;
        ArrayList<SteepDownArea> arrayList2 = new ArrayList<SteepDownArea>();
        Clustering<OPTICSModel> clustering = new Clustering<OPTICSModel>("OPTICS Xi-Clusters", "optics");
        HashSet<Cluster<OPTICSModel>> hashSet = new HashSet<Cluster<OPTICSModel>>();
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(relation.getDBIDs());
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("OPTICS Xi cluster extraction", arrayModifiableDBIDs.size(), LOG) : null;
        Cluster<OPTICSModel> cluster = new SteepScanPosition(clusterOrder);
        while (((SteepScanPosition)((Object)cluster)).hasNext()) {
            int n2;
            if (finiteProgress != null) {
                finiteProgress.setProcessed(((SteepScanPosition)((Object)cluster)).index, LOG);
            }
            d2 = MathUtil.max(d2, ((SteepScanPosition)((Object)cluster)).getReachability());
            if (!((SteepScanPosition)((Object)cluster)).next.valid()) break;
            if (((SteepScanPosition)((Object)cluster)).steepDown(d)) {
                OPTICSXi.updateFilterSDASet(d2, arrayList2, d);
                double d3 = ((SteepScanPosition)((Object)cluster)).getReachability();
                d2 = 0.0;
                n2 = ((SteepScanPosition)((Object)cluster)).index;
                int n6 = ((SteepScanPosition)((Object)cluster)).index + 1;
                ((SteepScanPosition)((Object)cluster)).next();
                while (((SteepScanPosition)((Object)cluster)).hasNext()) {
                    if (((SteepScanPosition)((Object)cluster)).steepDown(d)) {
                        n6 = ((SteepScanPosition)((Object)cluster)).index + 1;
                    } else if (!((SteepScanPosition)((Object)cluster)).steepDown(1.0) || ((SteepScanPosition)((Object)cluster)).index - n6 > n) break;
                    ((SteepScanPosition)((Object)cluster)).next();
                }
                SteepDownArea steepDownArea = new SteepDownArea(n2, n6, d3, 0.0);
                if (LOG.isDebuggingFinest()) {
                    LOG.debugFinest("New steep down area: " + steepDownArea.toString());
                }
                arrayList2.add(steepDownArea);
                if (arrayList == null) continue;
                arrayList.add(steepDownArea);
                continue;
            }
            if (((SteepScanPosition)((Object)cluster)).steepUp(d)) {
                OPTICSXi.updateFilterSDASet(d2, arrayList2, d);
                int n4 = ((SteepScanPosition)((Object)cluster)).index;
                n2 = ((SteepScanPosition)((Object)cluster)).index + 1;
                d2 = ((SteepScanPosition)((Object)cluster)).getReachability();
                double d3 = ((SteepScanPosition)((Object)cluster)).getNextReachability();
                if (!Double.isInfinite(d3)) {
                    ((SteepScanPosition)((Object)cluster)).next();
                    while (((SteepScanPosition)((Object)cluster)).hasNext()) {
                        if (((SteepScanPosition)((Object)cluster)).steepUp(d)) {
                            n2 = ((SteepScanPosition)((Object)cluster)).index + 1;
                            d2 = ((SteepScanPosition)((Object)cluster)).getReachability();
                            d3 = ((SteepScanPosition)((Object)cluster)).getNextReachability();
                            if (d3 == Double.POSITIVE_INFINITY) {
                                --n2;
                                break;
                            }
                        } else if (!((SteepScanPosition)((Object)cluster)).steepUp(1.0) || ((SteepScanPosition)((Object)cluster)).index - n2 > n) break;
                        ((SteepScanPosition)((Object)cluster)).next();
                    }
                } else {
                    --n2;
                    ((SteepScanPosition)((Object)cluster)).next();
                }
                SteepUpArea steepUpArea = new SteepUpArea(n4, n2, d3);
                if (LOG.isDebuggingFinest()) {
                    LOG.debugFinest("New steep up area: " + steepUpArea.toString());
                }
                if (arrayList != null) {
                    arrayList.add(steepUpArea);
                }
                ListIterator object = arrayList2.listIterator(arrayList2.size());
                while (object.hasPrevious()) {
                    int n3;
                    SteepDownArea steepDownArea = (SteepDownArea)object.previous();
                    if (LOG.isDebuggingFinest()) {
                        LOG.debugFinest("Comparing: eU=" + d2 + " SDA: " + steepDownArea.toString());
                    }
                    if (d2 * d < steepDownArea.getMib()) {
                        if (!LOG.isDebuggingFinest()) continue;
                        LOG.debugFinest("mib * ixi = " + d2 * d + " >= sda.getMib() = " + steepDownArea.getMib());
                        continue;
                    }
                    int n5 = steepDownArea.getStartIndex();
                    if (!this.nocorrect) {
                        for (n3 = steepUpArea.getEndIndex(); n3 > n5 && Double.isInfinite(writableDoubleDataStore.doubleValue(dBIDArrayIter.seek(n3))); --n3) {
                        }
                    }
                    if (steepDownArea.getMaximum() * d >= steepUpArea.getMaximum()) {
                        while (n5 < n3 && writableDoubleDataStore.doubleValue(dBIDArrayIter.seek(n5 + 1)) > steepUpArea.getMaximum()) {
                            ++n5;
                        }
                    } else if (steepUpArea.getMaximum() * d >= steepDownArea.getMaximum()) {
                        while (n3 > n5 && writableDoubleDataStore.doubleValue(dBIDArrayIter.seek(n3 - 1)) > steepDownArea.getMaximum()) {
                            --n3;
                        }
                    }
                    if (!this.nocorrect) {
                        block7: while (n3 > n5) {
                            clusterOrder.predecessor.assignVar(dBIDArrayIter.seek(n3), dBIDVar);
                            for (int i = n5; i < n3; ++i) {
                                if (DBIDUtil.equal(dBIDVar, dBIDArrayIter.seek(i))) break block7;
                            }
                            --n3;
                        }
                    }
                    if (n3 - n5 + 1 < n) {
                        if (!LOG.isDebuggingFinest()) continue;
                        LOG.debugFinest("MinPts not satisfied.");
                        continue;
                    }
                    ArrayModifiableDBIDs arrayModifiableDBIDs2 = DBIDUtil.newArray();
                    for (int i = n5; i <= n3; ++i) {
                        dBIDArrayIter.seek(i);
                        if (!hashSetModifiableDBIDs.remove(dBIDArrayIter)) continue;
                        arrayModifiableDBIDs2.add(dBIDArrayIter);
                    }
                    if (LOG.isDebuggingFine()) {
                        LOG.debugFine("Found cluster with " + arrayModifiableDBIDs2.size() + " new objects, length " + (n3 - n5 + 1));
                    }
                    OPTICSModel oPTICSModel = new OPTICSModel(n5, n3);
                    Cluster<OPTICSModel> cluster2 = new Cluster<OPTICSModel>("Cluster_" + n5 + "_" + n3, (DBIDs)arrayModifiableDBIDs2, oPTICSModel);
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        Cluster cluster3 = (Cluster)iterator.next();
                        OPTICSModel oPTICSModel2 = (OPTICSModel)cluster3.getModel();
                        if (oPTICSModel.getStartIndex() > oPTICSModel2.getStartIndex() || oPTICSModel2.getEndIndex() > oPTICSModel.getEndIndex()) continue;
                        clustering.addChildCluster(cluster2, cluster3);
                        iterator.remove();
                    }
                    hashSet.add(cluster2);
                }
                continue;
            }
            ((SteepScanPosition)((Object)cluster)).next();
        }
        if (finiteProgress != null) {
            finiteProgress.setProcessed(arrayModifiableDBIDs.size(), LOG);
        }
        if (hashSet.size() > 0 || hashSetModifiableDBIDs.size() > 0) {
            if (hashSetModifiableDBIDs.size() > 0) {
                cluster = writableDoubleDataStore.doubleValue(dBIDArrayIter.seek(arrayModifiableDBIDs.size() - 1)) >= Double.POSITIVE_INFINITY ? new Cluster<OPTICSModel>("Noise", hashSetModifiableDBIDs, true, new OPTICSModel(0, arrayModifiableDBIDs.size() - 1)) : new Cluster<OPTICSModel>("Cluster", (DBIDs)hashSetModifiableDBIDs, new OPTICSModel(0, arrayModifiableDBIDs.size() - 1));
                for (Cluster cluster4 : hashSet) {
                    clustering.addChildCluster(cluster, cluster4);
                }
                clustering.addToplevelCluster(cluster);
            } else {
                for (Cluster cluster4 : hashSet) {
                    clustering.addToplevelCluster(cluster4);
                }
            }
            clustering.addChildResult(clusterOrder);
            if (arrayList != null) {
                clusterOrder.addChildResult(new SteepAreaResult(arrayList));
            }
            return clustering;
        }
        return null;
    }

    private static void updateFilterSDASet(double d, List<SteepDownArea> list, double d2) {
        Iterator<SteepDownArea> iterator = list.iterator();
        while (iterator.hasNext()) {
            SteepDownArea steepDownArea = iterator.next();
            if (steepDownArea.getMaximum() * d2 <= d) {
                iterator.remove();
                continue;
            }
            if (!(d > steepDownArea.getMib())) continue;
            steepDownArea.setMib(d);
        }
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return this.optics.getInputTypeRestriction();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID XIALG_ID = new OptionID("opticsxi.algorithm", "The actual OPTICS-type algorithm to use.");
        public static final OptionID XI_ID = new OptionID("opticsxi.xi", "Threshold for the steepness requirement.");
        public static final OptionID NOCORRECT_ID = new OptionID("opticsxi.nocorrect", "Disable the predecessor correction.");
        public static final OptionID KEEPSTEEP_ID = new OptionID("opticsxi.keepsteep", "Keep the steep up/down areas of the plot.");
        protected OPTICSTypeAlgorithm optics;
        protected double xi = 0.0;
        protected boolean nocorrect = false;
        protected boolean keepsteep = false;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            Flag flag2;
            ClassParameter classParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = (DoubleParameter)((DoubleParameter)new DoubleParameter(XI_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).addConstraint(CommonConstraints.LESS_THAN_ONE_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.xi = doubleParameter.doubleValue();
            }
            if (parameterization.grab(classParameter = new ClassParameter(XIALG_ID, OPTICSTypeAlgorithm.class, OPTICSHeap.class))) {
                this.optics = (OPTICSTypeAlgorithm)classParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(flag2 = new Flag(NOCORRECT_ID))) {
                this.nocorrect = flag2.isTrue();
            }
            if (parameterization.grab(flag = new Flag(KEEPSTEEP_ID))) {
                this.keepsteep = flag.isTrue();
            }
        }

        @Override
        protected OPTICSXi makeInstance() {
            return new OPTICSXi(this.optics, this.xi, this.nocorrect, this.keepsteep);
        }
    }

    public static class SteepAreaResult
    implements IterableResult<SteepArea> {
        Collection<SteepArea> areas;

        public SteepAreaResult(Collection<SteepArea> collection) {
            this.areas = collection;
        }

        @Override
        public String getLongName() {
            return "Xi-Steep areas";
        }

        @Override
        public String getShortName() {
            return "xi-steep-areas";
        }

        @Override
        public Iterator<SteepArea> iterator() {
            return this.areas.iterator();
        }
    }

    public static class SteepUpArea
    extends SteepArea {
        public SteepUpArea(int n, int n2, double d) {
            super(n, n2, d);
        }

        public String toString() {
            return "SteepUpArea(" + this.getStartIndex() + " - " + this.getEndIndex() + ", max=" + this.getMaximum() + ")";
        }
    }

    public static class SteepDownArea
    extends SteepArea {
        private double mib;

        public SteepDownArea(int n, int n2, double d, double d2) {
            super(n, n2, d);
            this.mib = d2;
        }

        public double getMib() {
            return this.mib;
        }

        public void setMib(double d) {
            this.mib = d;
        }

        public String toString() {
            return "SteepDownArea(" + this.getStartIndex() + " - " + this.getEndIndex() + ", max=" + this.getMaximum() + ", mib=" + this.mib + ")";
        }
    }

    public static abstract class SteepArea {
        private int startindex;
        private int endindex;
        private double maximum;

        public SteepArea(int n, int n2, double d) {
            this.startindex = n;
            this.endindex = n2;
            this.maximum = d;
        }

        public int getStartIndex() {
            return this.startindex;
        }

        public int getEndIndex() {
            return this.endindex;
        }

        public double getMaximum() {
            return this.maximum;
        }
    }

    private static class SteepScanPosition {
        ClusterOrder co;
        int index;
        private DBIDArrayIter cur;
        private DBIDArrayIter next;

        public SteepScanPosition(ClusterOrder clusterOrder) {
            this.co = clusterOrder;
            this.index = 0;
            this.cur = clusterOrder.ids.iter();
            this.next = clusterOrder.ids.iter();
            if (this.next.valid()) {
                this.next.advance();
            }
        }

        public void next() {
            ++this.index;
            this.cur.advance();
            this.next.advance();
        }

        public boolean hasNext() {
            return this.index < this.co.size();
        }

        public boolean steepUp(double d) {
            if (this.co.reachability.doubleValue(this.cur) >= Double.POSITIVE_INFINITY) {
                return false;
            }
            if (!this.next.valid()) {
                return true;
            }
            return this.co.reachability.doubleValue(this.cur) <= this.co.reachability.doubleValue(this.next) * d;
        }

        public boolean steepDown(double d) {
            if (!this.next.valid()) {
                return false;
            }
            if (this.co.reachability.doubleValue(this.next) >= Double.POSITIVE_INFINITY) {
                return false;
            }
            return this.co.reachability.doubleValue(this.cur) * d >= this.co.reachability.doubleValue(this.next);
        }

        public double getReachability() {
            return this.co.reachability.doubleValue(this.cur);
        }

        public double getNextReachability() {
            return this.next.valid() ? this.co.reachability.doubleValue(this.next) : Double.POSITIVE_INFINITY;
        }
    }
}

