/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.subspace;

import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.GeneralizedDBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.PreDeConCorePredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.PreDeConNeighborPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="PreDeCon: Subspace Preference weighted Density Connected Clustering")
@Description(value="PreDeCon computes clusters of subspace preference weighted connected points. The algorithm searches for local subgroups of a set of feature vectors having a low variance along one or more (but not all) attributes.")
@Reference(authors="C. B\u00f6hm, K. Kailing, H.-P. Kriegel, P. Kr\u00f6ger", title="Density Connected Clustering with Local Subspace Preferences", booktitle="Proc. 4th IEEE Int. Conf. on Data Mining (ICDM'04), Brighton, UK, 2004", url="http://dx.doi.org/10.1109/ICDM.2004.10087")
public class PreDeCon<V extends NumberVector>
extends GeneralizedDBSCAN {
    private static final Logging LOG = Logging.getLogger(PreDeCon.class);

    public PreDeCon(Settings settings) {
        super(new PreDeConNeighborPredicate(settings), new PreDeConCorePredicate(settings), false);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        protected Settings settings;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            this.settings = parameterization.tryInstantiate(Settings.class);
        }

        @Override
        protected PreDeCon<V> makeInstance() {
            return new PreDeCon(this.settings);
        }
    }

    public static class Settings {
        public double epsilon;
        public double delta;
        public double kappa = 20.0;
        public int minpts;
        public int lambda = Integer.MAX_VALUE;

        public static class Parameterizer
        extends AbstractParameterizer {
            public static final OptionID DELTA_ID = new OptionID("predecon.delta", "A double specifying the variance threshold for small Eigenvalues.");
            public static final OptionID KAPPA_ID = new OptionID("predecon.kappa", "Penalty factor for deviations in preferred (low-variance) dimensions.");
            public static final double KAPPA_DEFAULT = 20.0;
            public static final OptionID LAMBDA_ID = new OptionID("predecon.lambda", "Maximum dimensionality to consider for core points.");
            Settings settings;

            @Override
            public void makeOptions(Parameterization parameterization) {
                this.settings = new Settings();
                this.configEpsilon(parameterization);
                this.configMinPts(parameterization);
                this.configDelta(parameterization);
                this.configKappa(parameterization);
                this.configLambda(parameterization);
            }

            protected void configEpsilon(Parameterization parameterization) {
                DoubleParameter doubleParameter = (DoubleParameter)new DoubleParameter(DBSCAN.Parameterizer.EPSILON_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
                if (parameterization.grab(doubleParameter)) {
                    this.settings.epsilon = doubleParameter.doubleValue();
                }
            }

            protected void configMinPts(Parameterization parameterization) {
                IntParameter intParameter = (IntParameter)new IntParameter(DBSCAN.Parameterizer.MINPTS_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (parameterization.grab(intParameter)) {
                    this.settings.minpts = intParameter.intValue();
                }
            }

            protected void configDelta(Parameterization parameterization) {
                DoubleParameter doubleParameter = (DoubleParameter)new DoubleParameter(DELTA_ID).addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
                if (parameterization.grab(doubleParameter)) {
                    this.settings.delta = doubleParameter.doubleValue();
                }
            }

            protected void configKappa(Parameterization parameterization) {
                DoubleParameter doubleParameter = (DoubleParameter)((DoubleParameter)new DoubleParameter(KAPPA_ID).addConstraint(CommonConstraints.GREATER_THAN_ONE_DOUBLE)).setDefaultValue((Object)20.0);
                if (parameterization.grab(doubleParameter)) {
                    this.settings.kappa = doubleParameter.doubleValue();
                }
            }

            protected void configLambda(Parameterization parameterization) {
                IntParameter intParameter = (IntParameter)((IntParameter)new IntParameter(LAMBDA_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT)).setOptional(true);
                if (parameterization.grab(intParameter)) {
                    this.settings.lambda = intParameter.intValue();
                }
            }

            @Override
            public Settings makeInstance() {
                return this.settings;
            }
        }
    }
}

