/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.uncertain;

import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.GeneralizedDBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.MinPtsCorePredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.uncertain.FDBSCANNeighborPredicate;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;

@Title(value="FDBSCAN: Density-based Clustering of Applications with Noise on fuzzy objects")
@Description(value="Algorithm to find density-connected sets in a database consisting of uncertain/fuzzy objects based on the parameters 'minpts', 'epsilon', 'samplesize', and (if used) 'threshold'")
@Reference(authors="H.-P. Kriegel and M. Pfeifle", title="Density-based clustering of uncertain data", booktitle="KDD05", url="http://dx.doi.org/10.1145/1081870.1081955")
public class FDBSCAN
extends GeneralizedDBSCAN {
    public FDBSCAN(double d, int n, double d2, RandomFactory randomFactory, int n2) {
        super(new FDBSCANNeighborPredicate(d, n, d2, randomFactory), new MinPtsCorePredicate(n2), false);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected double epsilon;
        protected int sampleSize;
        protected double threshold;
        protected RandomFactory seed;
        protected int minPts;

        @Override
        public void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            DoubleParameter doubleParameter;
            IntParameter intParameter;
            IntParameter intParameter2;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = (DoubleParameter)new DoubleParameter(DBSCAN.Parameterizer.EPSILON_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter2)) {
                this.epsilon = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(intParameter2 = (IntParameter)new IntParameter(DBSCAN.Parameterizer.MINPTS_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.minPts = intParameter2.intValue();
            }
            if (parameterization.grab(intParameter = (IntParameter)new IntParameter(FDBSCANNeighborPredicate.Parameterizer.SAMPLE_SIZE_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.sampleSize = (Integer)intParameter.getValue();
            }
            if (parameterization.grab(doubleParameter = (DoubleParameter)((DoubleParameter)new DoubleParameter(FDBSCANNeighborPredicate.Parameterizer.THRESHOLD_ID, 0.5).addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint(CommonConstraints.LESS_EQUAL_ONE_DOUBLE))) {
                this.threshold = (Double)doubleParameter.getValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(FDBSCANNeighborPredicate.Parameterizer.SEED_ID))) {
                this.seed = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected FDBSCAN makeInstance() {
            return new FDBSCAN(this.epsilon, this.sampleSize, this.threshold, this.seed, this.minPts);
        }
    }
}

