/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.distance;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="B. Yu, and M. Song, and L. Wang", title="Local Isolation Coefficient-Based Outlier Mining Algorithm", booktitle="Int. Conf. on Information Technology and Computer Science (ITCS) 2009", url="http://dx.doi.org/10.1109/ITCS.2009.230")
public class LocalIsolationCoefficient<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(LocalIsolationCoefficient.class);
    private int k;

    public LocalIsolationCoefficient(DistanceFunction<? super O> distanceFunction, int n) {
        super(distanceFunction);
        this.k = n;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        Object object;
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> kNNQuery = database.getKNNQuery(distanceQuery, this.k + 1);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Compute Local Isolation Coefficients", relation.size(), LOG) : null;
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        Object object2 = relation.iterDBIDs();
        while (object2.valid()) {
            object = kNNQuery.getKNNForDBID((DBIDRef)object2, this.k + 1);
            double d = 0.0;
            int n = 0;
            DoubleDBIDListIter doubleDBIDListIter = object.iter();
            while (n < this.k && doubleDBIDListIter.valid()) {
                if (!DBIDUtil.equal((DBIDRef)object2, doubleDBIDListIter)) {
                    d += doubleDBIDListIter.doubleValue();
                    ++n;
                }
                doubleDBIDListIter.advance();
            }
            double d2 = object.getKNNDistance() + (n > 0 ? d / (double)n : 0.0);
            writableDoubleDataStore.putDouble((DBIDRef)object2, d2);
            doubleMinMax.put(d);
            LOG.incrementProcessed(finiteProgress);
            object2.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        object2 = new MaterializedDoubleRelation("Local Isolation Coefficient", "lic-outlier", writableDoubleDataStore, relation.getDBIDs());
        object = new BasicOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult((OutlierScoreMeta)object, (DoubleRelation)object2);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("lic.k", "The k nearest neighbor, excluding the query point (i.e. query point is the 0-nearest-neighbor)");
        protected int k = 0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(K_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected LocalIsolationCoefficient<O> makeInstance() {
            return new LocalIsolationCoefficient(this.distanceFunction, this.k);
        }
    }
}

