/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.DoubleIntegerArrayQuickSort;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.Arrays;

@Title(value="LOCI: Fast Outlier Detection Using the Local Correlation Integral")
@Description(value="Algorithm to compute outliers based on the Local Correlation Integral")
@Reference(authors="S. Papadimitriou, H. Kitagawa, P. B. Gibbons, C. Faloutsos", title="LOCI: Fast Outlier Detection Using the Local Correlation Integral", booktitle="Proc. 19th IEEE Int. Conf. on Data Engineering (ICDE '03)", url="http://dx.doi.org/10.1109/ICDE.2003.1260802")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.LOCI"})
public class LOCI<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(LOCI.class);
    private double rmax;
    private int nmin = 0;
    private double alpha = 0.5;

    public LOCI(DistanceFunction<? super O> distanceFunction, double d, int n, double d2) {
        super(distanceFunction);
        this.rmax = d;
        this.nmin = n;
        this.alpha = d2;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        Object object;
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        RangeQuery<O> rangeQuery = database.getRangeQuery(distanceQuery, new Object[0]);
        DBIDs dBIDs = relation.getDBIDs();
        WritableDataStore<DoubleIntArrayList> writableDataStore = DataStoreUtil.makeStorage(relation.getDBIDs(), 9, DoubleIntArrayList.class);
        this.precomputeInterestingRadii(dBIDs, rangeQuery, writableDataStore);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("LOCI scores", relation.size(), LOG) : null;
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        WritableDoubleDataStore writableDoubleDataStore2 = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        MeanVariance meanVariance = new MeanVariance();
        Object object2 = dBIDs.iter();
        while (object2.valid()) {
            object = (DoubleIntArrayList)writableDataStore.get((DBIDRef)object2);
            double d = ((DoubleIntArrayList)object).getDouble(((DoubleIntArrayList)object).size() - 1);
            int n = ((DoubleIntArrayList)object).getInt(((DoubleIntArrayList)object).size() - 1);
            double d2 = 0.0;
            double d3 = 0.0;
            if (n >= this.nmin) {
                DoubleDBIDList doubleDBIDList = rangeQuery.getRangeForDBID((DBIDRef)object2, d);
                int n2 = ((DoubleIntArrayList)object).size();
                for (int i = 0; i < n2; ++i) {
                    double d4;
                    double d5;
                    if (((DoubleIntArrayList)object).getInt(i) < this.nmin) continue;
                    double d6 = ((DoubleIntArrayList)object).getDouble(i);
                    double d7 = this.alpha * d6;
                    int n3 = ((DoubleIntArrayList)object).getInt(((DoubleIntArrayList)object).find(d7));
                    meanVariance.reset();
                    DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
                    while (doubleDBIDListIter.valid() && !(doubleDBIDListIter.doubleValue() > d6)) {
                        DoubleIntArrayList doubleIntArrayList = (DoubleIntArrayList)writableDataStore.get(doubleDBIDListIter);
                        int n4 = doubleIntArrayList.getInt(doubleIntArrayList.find(d7));
                        meanVariance.put(n4);
                        doubleDBIDListIter.advance();
                    }
                    double d8 = meanVariance.getMean();
                    double d9 = d8 - (double)n3;
                    double d10 = d9 / (d5 = (d4 = meanVariance.getNaiveStddev()));
                    if (!(d10 > d2)) continue;
                    d2 = d10;
                    d3 = d6;
                }
            } else {
                d2 = Double.POSITIVE_INFINITY;
                d3 = d;
            }
            writableDoubleDataStore.putDouble((DBIDRef)object2, d2);
            writableDoubleDataStore2.putDouble((DBIDRef)object2, d3);
            doubleMinMax.put(d2);
            LOG.incrementProcessed(finiteProgress);
            object2.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        object2 = new MaterializedDoubleRelation("LOCI normalized MDEF", "loci-mdef-outlier", writableDoubleDataStore, relation.getDBIDs());
        object = new QuotientOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        OutlierResult outlierResult = new OutlierResult((OutlierScoreMeta)object, (DoubleRelation)object2);
        outlierResult.addChildResult(new MaterializedDoubleRelation("LOCI MDEF Radius", "loci-critical-radius", writableDoubleDataStore2, relation.getDBIDs()));
        return outlierResult;
    }

    protected void precomputeInterestingRadii(DBIDs dBIDs, RangeQuery<O> rangeQuery, WritableDataStore<DoubleIntArrayList> writableDataStore) {
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("LOCI preprocessing", dBIDs.size(), LOG) : null;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            DoubleDBIDList doubleDBIDList = rangeQuery.getRangeForDBID(dBIDIter, this.rmax);
            DoubleIntArrayList doubleIntArrayList = new DoubleIntArrayList(doubleDBIDList.size() << 1);
            int n = 0;
            DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
            while (doubleDBIDListIter.valid()) {
                double d;
                double d2 = doubleDBIDListIter.doubleValue();
                ++n;
                doubleDBIDListIter.advance();
                if (doubleDBIDListIter.valid() && d2 == doubleDBIDListIter.doubleValue()) continue;
                doubleIntArrayList.append(d2, n);
                if (this.alpha == 1.0 || !((d = d2 / this.alpha) <= this.rmax)) continue;
                doubleIntArrayList.append(d, Integer.MIN_VALUE);
            }
            doubleIntArrayList.sort();
            n = 0;
            int n2 = doubleIntArrayList.size();
            for (int i = 0; i < n2; ++i) {
                int n3 = doubleIntArrayList.getInt(i);
                if (n3 == Integer.MIN_VALUE) {
                    doubleIntArrayList.setValue(i, n);
                    continue;
                }
                n = n3;
            }
            writableDataStore.put(dBIDIter, doubleIntArrayList);
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID RMAX_ID = new OptionID("loci.rmax", "The maximum radius of the neighborhood to be considered.");
        public static final OptionID NMIN_ID = new OptionID("loci.nmin", "Minimum neighborhood size to be considered.");
        public static final OptionID ALPHA_ID = new OptionID("loci.alpha", "Scaling factor for averaging neighborhood");
        protected double rmax;
        protected int nmin = 0;
        protected double alpha = 0.5;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            IntParameter intParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(RMAX_ID);
            if (parameterization.grab(doubleParameter2)) {
                this.rmax = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(intParameter = new IntParameter(NMIN_ID, 20))) {
                this.nmin = intParameter.intValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(ALPHA_ID, 0.5))) {
                this.alpha = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected LOCI<O> makeInstance() {
            return new LOCI(this.distanceFunction, this.rmax, this.nmin, this.alpha);
        }
    }

    protected static class DoubleIntArrayList {
        double[] keys;
        int[] vals;
        int size = 0;

        public DoubleIntArrayList(int n) {
            this.keys = new double[n];
            this.vals = new int[n];
            this.size = 0;
        }

        public int size() {
            return this.size;
        }

        public double getDouble(int n) {
            return this.keys[n];
        }

        public int getInt(int n) {
            return this.vals[n];
        }

        public void setValue(int n, int n2) {
            this.vals[n] = n2;
        }

        public void append(double d, int n) {
            if (this.size == this.keys.length) {
                this.keys = Arrays.copyOf(this.keys, this.size << 1);
                this.vals = Arrays.copyOf(this.vals, this.size << 1);
            }
            this.keys[this.size] = d;
            this.vals[this.size] = n;
            ++this.size;
        }

        public int find(double d) {
            int n = 0;
            int n2 = this.size - 1;
            while (n <= n2) {
                int n3 = n + n2 >>> 1;
                double d2 = this.keys[n3];
                if (d2 > d) {
                    n2 = n3 - 1;
                    continue;
                }
                n = n3 + 1;
            }
            return n2;
        }

        public void sort() {
            DoubleIntegerArrayQuickSort.sort(this.keys, this.vals, this.size);
        }
    }
}

