/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.meta;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.LOF;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.SubspaceEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.AbstractProgress;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import java.util.ArrayList;
import java.util.Random;

@Title(value="Feature Bagging for Outlier Detection")
@Reference(title="Feature Bagging for Outlier Detection", authors="A. Lazarevic, V. Kumar", booktitle="Proc. of the 11th ACM SIGKDD international conference on Knowledge discovery in data mining", url="http://dx.doi.org/10.1145/1081870.1081891")
public class FeatureBagging
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(FeatureBagging.class);
    protected int num = 1;
    protected boolean breadth = false;
    private RandomFactory rnd;
    private int k;

    public FeatureBagging(int n, int n2, boolean bl, RandomFactory randomFactory) {
        this.k = n;
        this.num = n2;
        this.breadth = bl;
        this.rnd = randomFactory;
    }

    public OutlierResult run(Database database, Relation<NumberVector> relation) {
        Object object;
        Object object2;
        int n = RelationUtil.dimensionality(relation);
        int n2 = n >> 1;
        int n3 = n - 1;
        Random random = this.rnd.getSingleThreadedRandom();
        ArrayList<OutlierResult> arrayList = new ArrayList<OutlierResult>(this.num);
        Object object3 = LOG.isVerbose() ? new FiniteProgress("LOF iterations", this.num, LOG) : null;
        for (int i = 0; i < this.num; ++i) {
            object2 = this.randomSubspace(n, n2, n3, random);
            object = new SubspaceEuclideanDistanceFunction((long[])object2);
            LOF<NumberVector> lOF = new LOF<NumberVector>(this.k, (DistanceFunction<NumberVector>)object);
            Pair<F, S>[] pairArray = lOF.run(database, relation);
            arrayList.add((OutlierResult)pairArray);
            LOG.incrementProcessed((AbstractProgress)object3);
        }
        LOG.ensureCompleted((FiniteProgress)object3);
        object3 = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        if (this.breadth) {
            object2 = LOG.isVerbose() ? new FiniteProgress("Combining results", relation.size(), LOG) : null;
            object = Pair.newPairArray(arrayList.size());
            int n4 = 0;
            for (OutlierResult outlierResult : arrayList) {
                object[n4] = new Pair<DBIDArrayMIter, DoubleRelation>(outlierResult.getOrdering().order(relation.getDBIDs()).iter(), outlierResult.getScores());
                ++n4;
            }
            for (n4 = 0; n4 < relation.size(); ++n4) {
                for (Pair pair : object) {
                    DBIDIter dBIDIter = (DBIDIter)pair.first;
                    if (dBIDIter.valid()) {
                        double d = ((DoubleRelation)pair.second).doubleValue(dBIDIter);
                        if (Double.isNaN(object3.doubleValue(dBIDIter))) {
                            object3.putDouble(dBIDIter, d);
                            doubleMinMax.put(d);
                        }
                        dBIDIter.advance();
                        continue;
                    }
                    LOG.warning("Incomplete result: Iterator does not contain |DB| DBIDs");
                }
                LOG.incrementProcessed((AbstractProgress)object2);
            }
            LOG.ensureCompleted((FiniteProgress)object2);
        } else {
            object2 = LOG.isVerbose() ? new FiniteProgress("Combining results", relation.size(), LOG) : null;
            object = relation.iterDBIDs();
            while (object.valid()) {
                double d = 0.0;
                for (OutlierResult outlierResult : arrayList) {
                    double d2 = outlierResult.getScores().doubleValue((DBIDRef)object);
                    if (Double.isNaN(d2)) continue;
                    d += d2;
                }
                object3.putDouble((DBIDRef)object, d);
                doubleMinMax.put(d);
                LOG.incrementProcessed((AbstractProgress)object2);
                object.advance();
            }
            LOG.ensureCompleted((FiniteProgress)object2);
        }
        object2 = new BasicOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax());
        object = new MaterializedDoubleRelation("Feature bagging", "fb-outlier", (DoubleDataStore)object3, relation.getDBIDs());
        return new OutlierResult((OutlierScoreMeta)object2, (DoubleRelation)object);
    }

    private long[] randomSubspace(int n, int n2, int n3, Random random) {
        int n4;
        long[] lArray = BitsUtil.zero(n);
        int[] nArray = new int[n];
        for (n4 = 0; n4 < n; ++n4) {
            nArray[n4] = n4;
        }
        n4 = n2 + random.nextInt(n3 - n2);
        for (int i = 0; i < n - n4; ++i) {
            int n5 = random.nextInt(n - i);
            BitsUtil.setI(lArray, nArray[n5]);
            nArray[n5] = nArray[n - i - 1];
        }
        return lArray;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID NUM_ID = new OptionID("fbagging.num", "The number of instances to use in the ensemble.");
        public static final OptionID BREADTH_ID = new OptionID("fbagging.breadth", "Use the breadth first combinations instead of the cumulative sum approach");
        public static final OptionID SEED_ID = new OptionID("fbagging.seed", "Specify a particular random seed.");
        protected int k = 2;
        protected int num = 1;
        protected boolean breadth = false;
        protected RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            Flag flag;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(LOF.Parameterizer.K_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = (Integer)intParameter.getValue();
            }
            IntParameter intParameter2 = new IntParameter(NUM_ID);
            intParameter2.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter2)) {
                this.num = (Integer)intParameter2.getValue();
            }
            if (parameterization.grab(flag = new Flag(BREADTH_ID))) {
                this.breadth = (Boolean)flag.getValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected FeatureBagging makeInstance() {
            return new FeatureBagging(this.k, this.num, this.breadth, this.rnd);
        }
    }
}

