/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.subspace;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.IntIntPair;
import java.util.ArrayList;

@Reference(authors="C.C. Aggarwal, P. S. Yu", title="Outlier detection for high dimensional data", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD 2001), Santa Barbara, CA, 2001", url="http://dx.doi.org/10.1145/375663.375668")
public abstract class AbstractAggarwalYuOutlier<V extends NumberVector>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    public static final short DONT_CARE = -1;
    public static final short GENE_OFFSET = 0;
    protected int phi;
    protected int k;

    public AbstractAggarwalYuOutlier(int n, int n2) {
        this.k = n;
        this.phi = n2;
    }

    protected ArrayList<ArrayList<DBIDs>> buildRanges(Relation<V> relation) {
        int n = RelationUtil.dimensionality(relation);
        int n2 = relation.size();
        ArrayList<ArrayList<DBIDs>> arrayList = new ArrayList<ArrayList<DBIDs>>();
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(relation.getDBIDs());
        VectorUtil.SortDBIDsBySingleDimension sortDBIDsBySingleDimension = new VectorUtil.SortDBIDsBySingleDimension(relation);
        double d = (double)n2 * 1.0 / (double)this.phi;
        for (int i = 0; i < n; ++i) {
            sortDBIDsBySingleDimension.setDimension(i);
            arrayModifiableDBIDs.sort(sortDBIDsBySingleDimension);
            ArrayList<ArrayModifiableDBIDs> arrayList2 = new ArrayList<ArrayModifiableDBIDs>(this.phi + 1);
            int n3 = 0;
            DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs.iter();
            for (int j = 1; j <= this.phi; ++j) {
                int n4 = j < this.phi ? (int)(d * (double)j) : n2;
                ArrayModifiableDBIDs arrayModifiableDBIDs2 = DBIDUtil.newArray(n4 - n3);
                dBIDArrayMIter.seek(n3);
                while (dBIDArrayMIter.getOffset() < n4) {
                    arrayModifiableDBIDs2.add(dBIDArrayMIter);
                    dBIDArrayMIter.advance();
                }
                n3 = n4;
                arrayList2.add(arrayModifiableDBIDs2);
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    protected static double sparsity(int n, int n2, int n3, double d) {
        double d2 = 1.0 / d;
        double d3 = MathUtil.powi(d2, n3);
        double d4 = ((double)n - (double)n2 * d3) / Math.sqrt((double)n2 * d3 * (1.0 - d3));
        return d4;
    }

    protected DBIDs computeSubspace(ArrayList<IntIntPair> arrayList, ArrayList<ArrayList<DBIDs>> arrayList2) {
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(arrayList2.get(arrayList.get((int)0).first).get(arrayList.get((int)0).second));
        for (int i = 1; i < arrayList.size(); ++i) {
            DBIDs dBIDs = arrayList2.get(arrayList.get((int)i).first).get(arrayList.get((int)i).second - 0);
            hashSetModifiableDBIDs.retainAll(dBIDs);
            if (hashSetModifiableDBIDs.size() == 0) break;
        }
        return hashSetModifiableDBIDs;
    }

    protected DBIDs computeSubspaceForGene(short[] sArray, ArrayList<ArrayList<DBIDs>> arrayList) {
        HashSetModifiableDBIDs hashSetModifiableDBIDs = null;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] == -1) continue;
            DBIDs dBIDs = arrayList.get(i).get(sArray[i] - 0);
            if (hashSetModifiableDBIDs == null) {
                hashSetModifiableDBIDs = DBIDUtil.newHashSet(dBIDs);
                continue;
            }
            hashSetModifiableDBIDs.retainAll(dBIDs);
        }
        assert (hashSetModifiableDBIDs != null) : "All genes set to '*', should not happen!";
        return hashSetModifiableDBIDs;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID PHI_ID = new OptionID("ay.phi", "The number of equi-depth grid ranges to use in each dimension.");
        public static final OptionID K_ID = new OptionID("ay.k", "Subspace dimensionality to search for.");
        protected int phi;
        protected int k;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            IntParameter intParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter2 = (IntParameter)new IntParameter(K_ID).addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter2)) {
                this.k = (Integer)intParameter2.getValue();
            }
            if (parameterization.grab(intParameter = (IntParameter)new IntParameter(PHI_ID).addConstraint(CommonConstraints.GREATER_THAN_ONE_INT))) {
                this.phi = (Integer)intParameter.getValue();
            }
        }
    }
}

