/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.svm;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;
import libsvm.svm_print_interface;
import libsvm.svm_problem;

@Reference(authors="B. Sch\u00f6lkopf, J. C. Platt, J. Shawe-Taylor, A. J. Smola, R. C. Williamson", title="Estimating the support of a high-dimensional distribution", booktitle="Neural computation 13.7")
public class LibSVMOneClassOutlierDetection<V extends NumberVector>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(LibSVMOneClassOutlierDetection.class);
    protected SVMKernel kernel = SVMKernel.RBF;
    static final svm_print_interface LOG_HELPER = new svm_print_interface(){

        @Override
        public void print(String string) {
            if (LOG.isVerbose()) {
                LOG.verbose(string);
            }
        }
    };

    public LibSVMOneClassOutlierDetection(SVMKernel sVMKernel) {
        this.kernel = sVMKernel;
    }

    public OutlierResult run(Relation<V> relation) {
        Object object;
        Object object2;
        int n = RelationUtil.dimensionality(relation);
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(relation.getDBIDs());
        svm.svm_set_print_string_function(LOG_HELPER);
        svm_parameter svm_parameter2 = new svm_parameter();
        svm_parameter2.svm_type = 2;
        svm_parameter2.kernel_type = 0;
        svm_parameter2.degree = 3;
        switch (this.kernel) {
            case LINEAR: {
                svm_parameter2.kernel_type = 0;
                break;
            }
            case QUADRATIC: {
                svm_parameter2.kernel_type = 1;
                svm_parameter2.degree = 2;
                break;
            }
            case CUBIC: {
                svm_parameter2.kernel_type = 1;
                svm_parameter2.degree = 3;
                break;
            }
            case RBF: {
                svm_parameter2.kernel_type = 2;
                break;
            }
            case SIGMOID: {
                svm_parameter2.kernel_type = 3;
                break;
            }
            default: {
                throw new AbortException("Invalid kernel parameter: " + (Object)((Object)this.kernel));
            }
        }
        svm_parameter2.nu = 0.05;
        svm_parameter2.coef0 = 0.0;
        svm_parameter2.cache_size = 100.0;
        svm_parameter2.C = 100.0;
        svm_parameter2.eps = 1.0E-4;
        svm_parameter2.p = 0.1;
        svm_parameter2.shrinking = 0;
        svm_parameter2.probability = 0;
        svm_parameter2.nr_weight = 0;
        svm_parameter2.weight_label = new int[0];
        svm_parameter2.weight = new double[0];
        svm_parameter2.gamma = 1.0E-4 / (double)n;
        svm_problem svm_problem2 = new svm_problem();
        svm_problem2.l = relation.size();
        svm_problem2.x = new svm_node[svm_problem2.l][];
        svm_problem2.y = new double[svm_problem2.l];
        Object object3 = arrayDBIDs.iter();
        for (int i = 0; i < svm_problem2.l && object3.valid(); ++i) {
            object2 = (NumberVector)relation.get((DBIDRef)object3);
            object = new svm_node[n];
            for (int j = 0; j < n; ++j) {
                object[j] = new svm_node();
                object[j].index = j + 1;
                object[j].value = object2.doubleValue(j);
            }
            svm_problem2.x[i] = object;
            svm_problem2.y[i] = 1.0;
            object3.advance();
        }
        if (LOG.isVerbose()) {
            LOG.verbose("Training one-class SVM...");
        }
        if ((object3 = svm.svm_check_parameter(svm_problem2, svm_parameter2)) != null) {
            LOG.warning("svm_check_parameter: " + (String)object3);
        }
        svm_model svm_model2 = svm.svm_train(svm_problem2, svm_parameter2);
        if (LOG.isVerbose()) {
            LOG.verbose("Predicting...");
        }
        object2 = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 30);
        object = new DoubleMinMax();
        Object object4 = arrayDBIDs.iter();
        Object object5 = new double[svm.svm_get_nr_class(svm_model2)];
        for (int i = 0; i < svm_problem2.l && object4.valid(); ++i) {
            NumberVector numberVector = (NumberVector)relation.get((DBIDRef)object4);
            svm_node[] svm_nodeArray = new svm_node[n];
            for (int j = 0; j < n; ++j) {
                svm_nodeArray[j] = new svm_node();
                svm_nodeArray[j].index = j + 1;
                svm_nodeArray[j].value = numberVector.doubleValue(j);
            }
            svm.svm_predict_values(svm_model2, svm_nodeArray, object5);
            double d = -object5[0] / svm_parameter2.gamma;
            object2.putDouble((DBIDRef)object4, d);
            ((DoubleMinMax)object).put(d);
            object4.advance();
        }
        object4 = new MaterializedDoubleRelation("One-Class SVM Decision", "svm-outlier", (DoubleDataStore)object2, arrayDBIDs);
        object5 = new BasicOutlierScoreMeta(((DoubleMinMax)object).getMin(), ((DoubleMinMax)object).getMax(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult((OutlierScoreMeta)object5, (DoubleRelation)object4);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        private static final OptionID KERNEL_ID = new OptionID("svm.kernel", "Kernel to use with SVM.");
        protected SVMKernel kernel = SVMKernel.RBF;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            EnumParameter<SVMKernel> enumParameter = new EnumParameter<SVMKernel>(KERNEL_ID, SVMKernel.class, SVMKernel.RBF);
            if (parameterization.grab(enumParameter)) {
                this.kernel = (SVMKernel)((Object)enumParameter.getValue());
            }
        }

        @Override
        protected LibSVMOneClassOutlierDetection<V> makeInstance() {
            return new LibSVMOneClassOutlierDetection(this.kernel);
        }
    }

    public static enum SVMKernel {
        LINEAR,
        QUADRATIC,
        CUBIC,
        RBF,
        SIGMOID;

    }
}

