/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.greedyensemble;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.application.greedyensemble.GreedyEnsembleExperiment;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.evaluation.scores.ROCEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.DecreasingVectorIter;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.VectorNonZero;
import de.lmu.ifi.dbs.elki.evaluation.similaritymatrix.ComputeSimilarityMatrixImage;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.ensemble.EnsembleVoting;
import de.lmu.ifi.dbs.elki.utilities.ensemble.EnsembleVotingMean;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.LinearScaling;
import de.lmu.ifi.dbs.elki.utilities.scaling.ScalingFunction;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.VisualizerParameterizer;
import de.lmu.ifi.dbs.elki.visualization.gui.SimpleSVGViewer;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj.SimilarityMatrixVisualizer;
import de.lmu.ifi.dbs.elki.workflow.InputStep;
import java.awt.image.BufferedImage;

@Reference(authors="E. Schubert, R. Wojdanowski, A. Zimek, H.-P. Kriegel", title="On Evaluation of Outlier Rankings and Outlier Scores", booktitle="Proc. 12th SIAM International Conference on Data Mining (SDM), Anaheim, CA, 2012.", url="http://dx.doi.org/10.1137/1.9781611972825.90")
public class VisualizePairwiseGainMatrix
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(VisualizePairwiseGainMatrix.class);
    private InputStep inputstep;
    private VisualizerParameterizer vispar;
    private ScalingFunction prescaling;
    private EnsembleVoting voting;

    public VisualizePairwiseGainMatrix(InputStep inputStep, ScalingFunction scalingFunction, EnsembleVoting ensembleVoting, VisualizerParameterizer visualizerParameterizer) {
        this.inputstep = inputStep;
        this.prescaling = scalingFunction;
        this.voting = ensembleVoting;
        this.vispar = visualizerParameterizer;
    }

    @Override
    public void run() {
        int n;
        DBID dBID;
        Database database = this.inputstep.getDatabase();
        ResultHierarchy resultHierarchy = database.getHierarchy();
        Relation<NumberVector> relation = database.getRelation(TypeUtil.NUMBER_VECTOR_FIELD, new Object[0]);
        Relation<String> relation2 = DatabaseUtil.guessLabelRepresentation(database);
        String string = relation2.get(dBID = DBIDUtil.deref(relation2.iterDBIDs()));
        if (!string.matches(".*by.?label.*")) {
            throw new AbortException("No 'by label' reference outlier found, which is needed for weighting!");
        }
        relation = GreedyEnsembleExperiment.applyPrescaling(this.prescaling, relation, dBID);
        int n2 = RelationUtil.dimensionality(relation);
        NumberVector numberVector = relation.get(dBID);
        VectorNonZero vectorNonZero = new VectorNonZero(numberVector);
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(relation.getDBIDs());
        arrayModifiableDBIDs.remove(dBID);
        arrayModifiableDBIDs.sort();
        int n3 = arrayModifiableDBIDs.size();
        double[][] dArray = new double[n3][n3];
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        DoubleMinMax doubleMinMax2 = new DoubleMinMax();
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Computing ensemble gain.", n3 * (n3 + 1) >> 1, LOG) : null;
        Object object = new double[2];
        int n4 = 0;
        DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs.iter();
        while (dBIDArrayMIter.valid()) {
            double d;
            NumberVector numberVector2 = relation.get(dBIDArrayMIter);
            dArray[n4][n4] = d = ROCEvaluation.computeROCAUC(vectorNonZero, new DecreasingVectorIter(numberVector2));
            LOG.incrementProcessed(finiteProgress);
            DBIDArrayMIter dBIDArrayMIter2 = arrayModifiableDBIDs.iter();
            dBIDArrayMIter2.seek(n4 + 1);
            for (int i = n4 + 1; i < n3; ++i) {
                double d2;
                NumberVector numberVector3 = relation.get(dBIDArrayMIter2);
                double[] dArray2 = new double[n2];
                for (int j = 0; j < n2; ++j) {
                    object[0] = numberVector2.doubleValue(j);
                    object[1] = numberVector3.doubleValue(j);
                    dArray2[j] = this.voting.combine((double[])object);
                }
                dArray[n4][i] = d2 = ROCEvaluation.computeROCAUC(vectorNonZero, new DecreasingVectorIter(new Vector(dArray2)));
                dArray[i][n4] = d2;
                doubleMinMax2.put(dArray[n4][i]);
                LOG.incrementProcessed(finiteProgress);
                dBIDArrayMIter2.advance();
            }
            dBIDArrayMIter.advance();
            ++n4;
        }
        LOG.ensureCompleted(finiteProgress);
        for (n = 0; n < n3; ++n) {
            for (int i = n + 1; i < n3; ++i) {
                double d = Math.max(dArray[n][n], dArray[i][i]);
                dArray[n][i] = (dArray[n][i] - d) / (1.0 - d);
                dArray[i][n] = (dArray[i][n] - d) / (1.0 - d);
                doubleMinMax.put(dArray[n][i]);
            }
        }
        for (n = 0; n < n3; ++n) {
            dArray[n][n] = 0.0;
        }
        LOG.verbose("Gain: " + doubleMinMax.toString() + " AUC: " + doubleMinMax2.toString());
        n = doubleMinMax.getMin() < -0.001 ? 1 : 0;
        object = n == 0 ? (Object)LinearScaling.fromMinMax(0.0, doubleMinMax.getMax()) : (Object)LinearScaling.fromMinMax(0.0, Math.max(doubleMinMax.getMax(), -doubleMinMax.getMin()));
        object = LinearScaling.fromMinMax(0.0, 0.5);
        BufferedImage bufferedImage = new BufferedImage(n3, n3, 1);
        for (int i = 0; i < n3; ++i) {
            for (int j = i; j < n3; ++j) {
                int n5;
                int n6;
                double d = dArray[i][j];
                if ((d = Math.max(-1.0, Math.min(1.0, ((LinearScaling)object).getScaled(d)))) >= 0.0) {
                    n6 = 0xFF & (int)(255.0 * d);
                    n5 = 0xFF000000 | n6 << 8;
                } else {
                    n6 = 0xFF & (int)(255.0 * -d);
                    n5 = 0xFF000000 | n6 << 16;
                }
                bufferedImage.setRGB(i, j, n5);
                bufferedImage.setRGB(j, i, n5);
            }
        }
        ComputeSimilarityMatrixImage.SimilarityMatrix similarityMatrix = new ComputeSimilarityMatrixImage.SimilarityMatrix(bufferedImage, relation, arrayModifiableDBIDs);
        resultHierarchy.add(database, similarityMatrix);
        VisualizerContext visualizerContext = this.vispar.newContext(resultHierarchy, similarityMatrix);
        SimilarityMatrixVisualizer similarityMatrixVisualizer = new SimilarityMatrixVisualizer();
        similarityMatrixVisualizer.processNewResult(visualizerContext, database);
        Hierarchy.Iter<VisualizationTask> iter = VisualizationTree.filter(visualizerContext, VisualizationTask.class);
        while (iter.valid()) {
            VisualizationTask visualizationTask = iter.get();
            if (visualizationTask.getFactory() == similarityMatrixVisualizer) {
                this.showVisualization(visualizerContext, similarityMatrixVisualizer, visualizationTask);
            }
            iter.advance();
        }
    }

    private void showVisualization(VisualizerContext visualizerContext, SimilarityMatrixVisualizer similarityMatrixVisualizer, VisualizationTask visualizationTask) {
        VisualizationPlot visualizationPlot = new VisualizationPlot();
        Visualization visualization = similarityMatrixVisualizer.makeVisualization(visualizationTask, visualizationPlot, 1.0, 1.0, null);
        visualizationPlot.getRoot().appendChild(visualization.getLayer());
        visualizationPlot.getRoot().setAttribute("width", "20cm");
        visualizationPlot.getRoot().setAttribute("height", "20cm");
        visualizationPlot.getRoot().setAttribute("viewBox", "0 0 1 1");
        visualizationPlot.updateStyleElement();
        new SimpleSVGViewer().setPlot(visualizationPlot);
    }

    public static void main(String[] stringArray) {
        VisualizePairwiseGainMatrix.runCLIApplication(VisualizePairwiseGainMatrix.class, stringArray);
    }

    public static class Parameterizer
    extends AbstractApplication.Parameterizer {
        private InputStep inputstep;
        private VisualizerParameterizer vispar;
        private ScalingFunction prescaling;
        private EnsembleVoting voting;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            this.inputstep = parameterization.tryInstantiate(InputStep.class);
            this.vispar = parameterization.tryInstantiate(VisualizerParameterizer.class);
            ObjectParameter objectParameter2 = new ObjectParameter(GreedyEnsembleExperiment.Parameterizer.PRESCALING_ID, ScalingFunction.class);
            objectParameter2.setOptional(true);
            if (parameterization.grab(objectParameter2)) {
                this.prescaling = (ScalingFunction)objectParameter2.instantiateClass(parameterization);
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(GreedyEnsembleExperiment.Parameterizer.VOTING_ID, (Class<?>)EnsembleVoting.class, EnsembleVotingMean.class))) {
                this.voting = (EnsembleVoting)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected VisualizePairwiseGainMatrix makeInstance() {
            return new VisualizePairwiseGainMatrix(this.inputstep, this.prescaling, this.voting, this.vispar);
        }
    }
}

