/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.result.BasicResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.HashMapHierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.ModifiableHierarchy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Clustering<M extends Model>
extends BasicResult {
    private List<Cluster<M>> toplevelclusters;
    private ModifiableHierarchy<Cluster<M>> hierarchy;

    public Clustering(String string, String string2, List<Cluster<M>> list) {
        super(string, string2);
        this.toplevelclusters = list;
        this.hierarchy = new HashMapHierarchy<Cluster<M>>();
        for (Cluster<M> cluster : list) {
            this.hierarchy.add(cluster);
        }
    }

    public Clustering(String string, String string2) {
        this(string, string2, new ArrayList<Cluster<M>>());
    }

    public void addToplevelCluster(Cluster<M> cluster) {
        this.toplevelclusters.add(cluster);
        this.hierarchy.add(cluster);
    }

    public void addChildCluster(Cluster<M> cluster, Cluster<M> cluster2) {
        this.hierarchy.add(cluster, cluster2);
    }

    public List<Cluster<M>> getToplevelClusters() {
        return this.toplevelclusters;
    }

    public Hierarchy<Cluster<M>> getClusterHierarchy() {
        return this.hierarchy;
    }

    public List<Cluster<M>> getAllClusters() {
        ArrayList<Cluster<M>> arrayList = new ArrayList<Cluster<M>>(this.hierarchy.size());
        Hierarchy.Iter iter = this.hierarchy.iterAll();
        while (iter.valid()) {
            arrayList.add((Cluster<M>)iter.get());
            iter.advance();
        }
        Collections.sort(arrayList, Cluster.BY_NAME_SORTER);
        return arrayList;
    }

    public Hierarchy.Iter<Cluster<M>> iterToplevelClusters() {
        return new Hierarchy.Iter<Cluster<M>>(){
            Iterator<Cluster<M>> iter;
            Cluster<M> cur;
            {
                this.iter = Clustering.this.toplevelclusters.iterator();
                this.advance();
            }

            @Override
            public boolean valid() {
                return this.cur != null;
            }

            @Override
            public Hierarchy.Iter<Cluster<M>> advance() {
                this.cur = this.iter.hasNext() ? this.iter.next() : null;
                return this;
            }

            @Override
            public Cluster<M> get() {
                return this.cur;
            }
        };
    }
}

