/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.projection;

import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.projection.Projection;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.filter.transform.NumberVectorFeatureSelectionFilter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.SubsetArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntListParameter;

public class FeatureSelection<V extends FeatureVector<F>, F>
implements Projection<V, V> {
    private int mindim;
    private FeatureVector.Factory<V, F> factory;
    private int dimensionality;
    protected ArrayAdapter<F, V> adapter;

    public FeatureSelection(int[] nArray) {
        this.adapter = new SubsetArrayAdapter<F, V>(FeatureSelection.getAdapter(this.factory), nArray);
        this.dimensionality = nArray.length;
        int n = 0;
        for (int n2 : nArray) {
            n = Math.max(n, n2 + 1);
        }
        this.mindim = n;
    }

    @Override
    public void initialize(SimpleTypeInformation<V> simpleTypeInformation) {
        VectorFieldTypeInformation vectorFieldTypeInformation = (VectorFieldTypeInformation)simpleTypeInformation;
        this.factory = vectorFieldTypeInformation.getFactory();
        if (vectorFieldTypeInformation.getDimensionality() < this.mindim) {
            throw new AbortException("Data does not have enough dimensions for this projection!");
        }
    }

    @Override
    public V project(V v) {
        return this.factory.newFeatureVector(v, this.adapter);
    }

    private static <V extends FeatureVector<F>, F> ArrayAdapter<F, ? super V> getAdapter(FeatureVector.Factory<V, F> factory) {
        if (factory instanceof NumberVector.Factory) {
            return ArrayLikeUtil.NUMBERVECTORADAPTER;
        }
        return ArrayLikeUtil.FEATUREVECTORADAPTER;
    }

    @Override
    public SimpleTypeInformation<V> getOutputDataTypeInformation() {
        return new VectorFieldTypeInformation<V>(this.factory, this.dimensionality);
    }

    @Override
    public TypeInformation getInputDataTypeInformation() {
        Class<V> clazz = this.factory.getRestrictionClass();
        return VectorTypeInformation.typeRequest(clazz, this.mindim, Integer.MAX_VALUE);
    }

    public static class Parameterizer<V extends FeatureVector<F>, F>
    extends AbstractParameterizer {
        int[] dims = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntListParameter intListParameter = new IntListParameter(NumberVectorFeatureSelectionFilter.Parameterizer.SELECTED_ATTRIBUTES_ID);
            intListParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT_LIST);
            if (parameterization.grab(intListParameter)) {
                this.dims = (int[])((int[])intListParameter.getValue()).clone();
            }
        }

        @Override
        protected FeatureSelection<V, F> makeInstance() {
            return new FeatureSelection(this.dims);
        }
    }
}

