/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.projection;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.projection.Projection;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.math.geodesy.EarthModel;
import de.lmu.ifi.dbs.elki.math.geodesy.SphericalVincentyEarthModel;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class LatLngToECEFProjection<V extends NumberVector>
implements Projection<V, V> {
    private NumberVector.Factory<V> factory;
    private EarthModel model;

    public LatLngToECEFProjection(EarthModel earthModel) {
        this.model = earthModel;
    }

    @Override
    public void initialize(SimpleTypeInformation<V> simpleTypeInformation) {
        VectorFieldTypeInformation vectorFieldTypeInformation = (VectorFieldTypeInformation)simpleTypeInformation;
        this.factory = (NumberVector.Factory)vectorFieldTypeInformation.getFactory();
    }

    @Override
    public V project(V v) {
        return this.factory.newNumberVector(this.model.latLngDegToECEF(v.doubleValue(0), v.doubleValue(1)));
    }

    @Override
    public SimpleTypeInformation<? super V> getInputDataTypeInformation() {
        return TypeUtil.NUMBER_VECTOR_FIELD_2D;
    }

    @Override
    public SimpleTypeInformation<V> getOutputDataTypeInformation() {
        return new VectorFieldTypeInformation(this.factory, 3, 3, this.factory.getDefaultSerializer());
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        EarthModel model;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(EarthModel.MODEL_ID, (Class<?>)EarthModel.class, SphericalVincentyEarthModel.class);
            if (parameterization.grab(objectParameter)) {
                this.model = (EarthModel)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected LatLngToECEFProjection<NumberVector> makeInstance() {
            return new LatLngToECEFProjection<NumberVector>(this.model);
        }
    }
}

