/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.AbstractDatabase;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayStaticDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DBIDView;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.FileBasedDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Collection;

@Description(value="Database using an in-memory hashtable and at least providing linear scans.")
public class StaticArrayDatabase
extends AbstractDatabase {
    private static final Logging LOG = Logging.getLogger(StaticArrayDatabase.class);
    private ArrayStaticDBIDs ids;
    private DBIDView idrep;
    protected DatabaseConnection databaseConnection;

    public StaticArrayDatabase(DatabaseConnection databaseConnection, Collection<IndexFactory<?, ?>> collection) {
        this.databaseConnection = databaseConnection;
        this.ids = null;
        this.idrep = null;
        if (collection != null) {
            this.indexFactories.addAll(collection);
        }
    }

    public StaticArrayDatabase() {
        this(null, null);
    }

    @Override
    public void initialize() {
        if (this.databaseConnection != null) {
            if (LOG.isDebugging()) {
                LOG.debugFine("Loading data from database connection.");
            }
            MultipleObjectsBundle multipleObjectsBundle = this.databaseConnection.loadData();
            this.databaseConnection = null;
            Object object = multipleObjectsBundle.getDBIDs();
            this.ids = object instanceof ArrayStaticDBIDs ? (ArrayStaticDBIDs)object : (object == null ? DBIDUtil.generateStaticDBIDRange(multipleObjectsBundle.dataLength()) : (ArrayStaticDBIDs)DBIDUtil.makeUnmodifiable((DBIDs)object));
            this.idrep = new DBIDView(this.ids);
            this.relations.add(this.idrep);
            this.getHierarchy().add(this, this.idrep);
            object = this.ids.iter();
            int n = multipleObjectsBundle.metaLength();
            for (int i = 0; i < n; ++i) {
                SimpleTypeInformation<?> simpleTypeInformation;
                SimpleTypeInformation<?> simpleTypeInformation2 = simpleTypeInformation = multipleObjectsBundle.meta(i);
                WritableDataStore<?> writableDataStore = DataStoreUtil.makeStorage(this.ids, 30, simpleTypeInformation2.getRestrictionClass());
                object.seek(0);
                while (object.valid()) {
                    writableDataStore.put((DBIDRef)object, multipleObjectsBundle.data(object.getOffset(), i));
                    object.advance();
                }
                MaterializedRelation materializedRelation = new MaterializedRelation(simpleTypeInformation2, this.ids, null, writableDataStore);
                this.relations.add(materializedRelation);
                this.getHierarchy().add(this, materializedRelation);
                for (IndexFactory indexFactory : this.indexFactories) {
                    if (!indexFactory.getInputTypeRestriction().isAssignableFromType(simpleTypeInformation2)) continue;
                    IndexFactory indexFactory2 = indexFactory;
                    MaterializedRelation materializedRelation2 = materializedRelation;
                    Object i2 = indexFactory2.instantiate(materializedRelation2);
                    Duration duration = LOG.isStatistics() ? LOG.newDuration(i2.getClass().getName() + ".construction").begin() : null;
                    i2.initialize();
                    if (duration != null) {
                        LOG.statistics(duration.end());
                    }
                    this.getHierarchy().add(materializedRelation, (Result)i2);
                }
            }
            this.eventManager.fireObjectsInserted(this.ids);
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractDatabase.Parameterizer {
        protected DatabaseConnection databaseConnection = null;
        private Collection<IndexFactory<?, ?>> indexFactories;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectListParameter objectListParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(DATABASE_CONNECTION_ID, (Class<?>)DatabaseConnection.class, FileBasedDatabaseConnection.class);
            if (parameterization.grab(objectParameter)) {
                this.databaseConnection = (DatabaseConnection)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(objectListParameter = new ObjectListParameter(INDEX_ID, IndexFactory.class, true))) {
                this.indexFactories = objectListParameter.instantiateClasses(parameterization);
            }
        }

        @Override
        protected StaticArrayDatabase makeInstance() {
            return new StaticArrayDatabase(this.databaseConnection, this.indexFactories);
        }
    }
}

