/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.generic;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;

public class MaskedDBIDs
implements DBIDs {
    protected ArrayDBIDs data;
    protected long[] bits;
    protected boolean inverse = false;

    public MaskedDBIDs(ArrayDBIDs arrayDBIDs, long[] lArray, boolean bl) {
        this.data = arrayDBIDs;
        this.bits = lArray;
        this.inverse = bl;
    }

    @Override
    public DBIDIter iter() {
        return this.inverse ? new InvDBIDItr() : new DBIDItr();
    }

    @Override
    public int size() {
        if (this.inverse) {
            return this.data.size() - BitsUtil.cardinality(this.bits);
        }
        return BitsUtil.cardinality(this.bits);
    }

    @Override
    public boolean contains(DBIDRef dBIDRef) {
        DBIDIter dBIDIter = this.iter();
        while (dBIDIter.valid()) {
            if (DBIDFactory.FACTORY.equal(dBIDIter, dBIDRef)) {
                return true;
            }
            dBIDIter.advance();
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return BitsUtil.isZero(this.bits);
    }

    protected class InvDBIDItr
    implements DBIDIter {
        private int pos;
        private DBIDArrayIter iter;

        protected InvDBIDItr() {
            this.pos = BitsUtil.nextClearBit(MaskedDBIDs.this.bits, 0);
            this.iter = MaskedDBIDs.this.data.iter();
        }

        @Override
        public boolean valid() {
            return this.pos >= 0 && this.pos < MaskedDBIDs.this.data.size();
        }

        @Override
        public DBIDIter advance() {
            this.pos = BitsUtil.nextClearBit(MaskedDBIDs.this.bits, this.pos + 1);
            return this;
        }

        @Override
        public int internalGetIndex() {
            this.iter.seek(this.pos);
            return this.iter.internalGetIndex();
        }
    }

    protected class DBIDItr
    implements DBIDIter {
        private int pos;
        private DBIDArrayIter iter;

        protected DBIDItr() {
            this.pos = BitsUtil.nextSetBit(MaskedDBIDs.this.bits, 0);
            this.iter = MaskedDBIDs.this.data.iter();
        }

        @Override
        public boolean valid() {
            return this.pos >= 0;
        }

        @Override
        public DBIDIter advance() {
            this.pos = BitsUtil.nextSetBit(MaskedDBIDs.this.bits, this.pos + 1);
            return this;
        }

        @Override
        public int internalGetIndex() {
            this.iter.seek(this.pos);
            return this.iter.internalGetIndex();
        }
    }
}

