/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.DBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.integer.ArrayModifiableIntegerDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDKNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBID;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.integer.TroveHashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.io.FixedSizeByteBufferSerializer;

abstract class AbstractIntegerDBIDFactory
implements DBIDFactory {
    DBID invalid = new IntegerDBID(Integer.MIN_VALUE);

    AbstractIntegerDBIDFactory() {
    }

    @Override
    public DBID importInteger(int n) {
        return new IntegerDBID(n);
    }

    @Override
    public void assignVar(DBIDVar dBIDVar, int n) {
        if (dBIDVar instanceof IntegerDBIDVar) {
            ((IntegerDBIDVar)dBIDVar).internalSetIndex(n);
        } else {
            dBIDVar.set(new IntegerDBID(n));
        }
    }

    @Override
    public int compare(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        int n;
        int n2 = dBIDRef.internalGetIndex();
        return n2 < (n = dBIDRef2.internalGetIndex()) ? -1 : (n2 == n ? 0 : 1);
    }

    @Override
    public boolean equal(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        return dBIDRef.internalGetIndex() == dBIDRef2.internalGetIndex();
    }

    @Override
    public String toString(DBIDRef dBIDRef) {
        return dBIDRef != null && dBIDRef.internalGetIndex() != Integer.MIN_VALUE ? Integer.toString(dBIDRef.internalGetIndex()) : "null";
    }

    @Override
    public DBIDVar newVar(DBIDRef dBIDRef) {
        return new IntegerDBIDVar(dBIDRef);
    }

    @Override
    public ArrayModifiableDBIDs newArray() {
        return new ArrayModifiableIntegerDBIDs();
    }

    @Override
    public HashSetModifiableDBIDs newHashSet() {
        return new TroveHashSetModifiableDBIDs();
    }

    @Override
    public ArrayModifiableDBIDs newArray(int n) {
        return new ArrayModifiableIntegerDBIDs(n);
    }

    @Override
    public HashSetModifiableDBIDs newHashSet(int n) {
        return new TroveHashSetModifiableDBIDs(n);
    }

    @Override
    public ArrayModifiableDBIDs newArray(DBIDs dBIDs) {
        return new ArrayModifiableIntegerDBIDs(dBIDs);
    }

    @Override
    public HashSetModifiableDBIDs newHashSet(DBIDs dBIDs) {
        return new TroveHashSetModifiableDBIDs(dBIDs);
    }

    @Override
    public DBIDPair newPair(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        return new IntegerDBIDPair(dBIDRef.internalGetIndex(), dBIDRef2.internalGetIndex());
    }

    @Override
    public DoubleDBIDPair newPair(double d, DBIDRef dBIDRef) {
        return new DoubleIntegerDBIDPair(d, dBIDRef.internalGetIndex());
    }

    @Override
    public KNNHeap newHeap(int n) {
        return new DoubleIntegerDBIDKNNHeap(n);
    }

    @Override
    public KNNHeap newHeap(KNNList kNNList) {
        KNNHeap kNNHeap = this.newHeap(kNNList.getK());
        for (int i = kNNList.size() - 1; i >= 0; --i) {
            kNNHeap.insert(kNNList.get(i));
        }
        return kNNHeap;
    }

    @Override
    public ModifiableDoubleDBIDList newDistanceDBIDList(int n) {
        return new DoubleIntegerDBIDList(n);
    }

    @Override
    public ModifiableDoubleDBIDList newDistanceDBIDList() {
        return new DoubleIntegerDBIDList();
    }

    @Override
    public ByteBufferSerializer<DBID> getDBIDSerializer() {
        return IntegerDBID.DYNAMIC_SERIALIZER;
    }

    @Override
    public FixedSizeByteBufferSerializer<DBID> getDBIDSerializerStatic() {
        return IntegerDBID.STATIC_SERIALIZER;
    }

    @Override
    public Class<? extends DBID> getTypeRestriction() {
        return IntegerDBID.class;
    }

    @Override
    public DBIDRef invalid() {
        return this.invalid;
    }
}

