/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDKNNList;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDPair;

class DoubleIntegerDBIDListKNNHeap
extends DoubleIntegerDBIDKNNList
implements KNNHeap {
    protected DoubleIntegerDBIDListKNNHeap(int n) {
        super(n, n + 11);
    }

    @Override
    protected final void addInternal(double d, int n) {
        if (this.size >= this.k && d > this.dists[this.k - 1]) {
            return;
        }
        this.insertionSort(d, n);
    }

    private void insertionSort(double d, int n) {
        int n2;
        double d2;
        if (this.size == this.dists.length) {
            this.grow();
        }
        int n3 = this.size;
        while (n3 > 0 && !((d2 = this.dists[n2 = n3 - 1]) <= d)) {
            this.dists[n3] = d2;
            this.ids[n3] = this.ids[n2];
            n3 = n2;
        }
        this.dists[n3] = d;
        this.ids[n3] = n;
        ++this.size;
        if (this.size > this.k && this.dists[this.k] > this.dists[this.k - 1]) {
            this.size = this.k;
        }
    }

    @Override
    public double insert(double d, DBIDRef dBIDRef) {
        int n = this.k - 1;
        int n2 = dBIDRef.internalGetIndex();
        if (this.size >= this.k && d > this.dists[n]) {
            return this.size >= this.k ? this.dists[n] : Double.POSITIVE_INFINITY;
        }
        this.insertionSort(d, n2);
        return this.size >= this.k ? this.dists[n] : Double.POSITIVE_INFINITY;
    }

    @Override
    public void add(double d, DBIDRef dBIDRef) {
        this.addInternal(d, dBIDRef.internalGetIndex());
    }

    @Override
    public void insert(DoubleDBIDPair doubleDBIDPair) {
        this.addInternal(doubleDBIDPair.doubleValue(), doubleDBIDPair.internalGetIndex());
    }

    @Override
    public DoubleIntegerDBIDPair poll() {
        int n = this.size - 1;
        return new DoubleIntegerDBIDPair(this.dists[n], this.ids[n]);
    }

    @Override
    public DoubleIntegerDBIDPair peek() {
        int n = this.size - 1;
        return new DoubleIntegerDBIDPair(this.dists[n], this.ids[n]);
    }

    @Override
    public KNNList toKNNList() {
        return this;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("kNNListHeap[");
        DoubleIntegerDBIDList.Itr itr = this.iter();
        while (itr.valid()) {
            stringBuilder.append(itr.doubleValue()).append(':').append(itr.internalGetIndex());
            itr.advance();
            if (!itr.valid()) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

