/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.distance;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.query.distance.AbstractDistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;

public class PrimitiveDistanceQuery<O>
extends AbstractDistanceQuery<O> {
    protected final PrimitiveDistanceFunction<? super O> distanceFunction;

    public PrimitiveDistanceQuery(Relation<? extends O> relation, PrimitiveDistanceFunction<? super O> primitiveDistanceFunction) {
        super(relation);
        this.distanceFunction = primitiveDistanceFunction;
    }

    @Override
    public double distance(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        Object o = this.relation.get(dBIDRef);
        Object o2 = this.relation.get(dBIDRef2);
        return this.distance(o, o2);
    }

    @Override
    public double distance(O o, DBIDRef dBIDRef) {
        Object o2 = this.relation.get(dBIDRef);
        return this.distance(o, o2);
    }

    @Override
    public double distance(DBIDRef dBIDRef, O o) {
        Object o2 = this.relation.get(dBIDRef);
        return this.distance(o2, o);
    }

    @Override
    public double distance(O o, O o2) {
        if (o == null) {
            throw new UnsupportedOperationException("This distance function can only be used for object instances.");
        }
        if (o2 == null) {
            throw new UnsupportedOperationException("This distance function can only be used for object instances.");
        }
        return this.distanceFunction.distance(o, o2);
    }

    @Override
    public PrimitiveDistanceFunction<? super O> getDistanceFunction() {
        return this.distanceFunction;
    }
}

