/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.relation;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.AbstractRelation;
import de.lmu.ifi.dbs.elki.logging.Logging;

public class DBIDView
extends AbstractRelation<DBID> {
    private static final Logging LOG = Logging.getLogger(DBIDView.class);
    private DBIDs ids;

    public DBIDView(DBIDs dBIDs) {
        this.ids = DBIDUtil.makeUnmodifiable(dBIDs);
    }

    @Override
    public DBID get(DBIDRef dBIDRef) {
        assert (this.ids.contains(dBIDRef));
        return DBIDUtil.deref(dBIDRef);
    }

    @Override
    public SimpleTypeInformation<DBID> getDataTypeInformation() {
        return TypeUtil.DBID;
    }

    @Override
    public DBIDs getDBIDs() {
        return this.ids;
    }

    @Override
    public DBIDIter iterDBIDs() {
        return this.ids.iter();
    }

    public void setDBIDs(DBIDs dBIDs) {
        this.ids = DBIDUtil.makeUnmodifiable(dBIDs);
    }

    @Override
    public int size() {
        return this.ids.size();
    }

    @Override
    public String getLongName() {
        return "Database IDs";
    }

    @Override
    public String getShortName() {
        return "DBID";
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

