/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.relation;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.StaticDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.AbstractRelation;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.logging.Logging;

public class MaterializedDoubleRelation
extends AbstractRelation<Double>
implements DoubleRelation {
    private static final Logging LOG = Logging.getLogger(MaterializedDoubleRelation.class);
    private final DoubleDataStore content;
    private final StaticDBIDs ids;
    private String name;
    private String shortname = "relation";

    public MaterializedDoubleRelation(DBIDs dBIDs) {
        this(dBIDs, null);
    }

    public MaterializedDoubleRelation(DBIDs dBIDs, String string) {
        this(dBIDs, string, DataStoreUtil.makeDoubleStorage(dBIDs, 30));
    }

    public MaterializedDoubleRelation(DBIDs dBIDs, String string, DoubleDataStore doubleDataStore) {
        this.ids = DBIDUtil.makeUnmodifiable(dBIDs);
        this.name = string;
        this.content = doubleDataStore;
    }

    public MaterializedDoubleRelation(String string, String string2, DoubleDataStore doubleDataStore, DBIDs dBIDs) {
        this.ids = DBIDUtil.makeUnmodifiable(dBIDs);
        this.name = string;
        this.shortname = string2;
        this.content = doubleDataStore;
    }

    @Override
    @Deprecated
    public Double get(DBIDRef dBIDRef) {
        return this.content.doubleValue(dBIDRef);
    }

    @Override
    public double doubleValue(DBIDRef dBIDRef) {
        return this.content.doubleValue(dBIDRef);
    }

    @Override
    public void set(DBIDRef dBIDRef, double d) {
        assert (this.ids.contains(dBIDRef));
        if (this.content instanceof WritableDoubleDataStore) {
            ((WritableDoubleDataStore)this.content).putDouble(dBIDRef, d);
        }
    }

    @Override
    @Deprecated
    public void insert(DBIDRef dBIDRef, Double d) {
        assert (this.ids.contains(dBIDRef));
        if (this.content instanceof WritableDoubleDataStore) {
            ((WritableDoubleDataStore)this.content).putDouble(dBIDRef, d);
        }
    }

    @Override
    public void delete(DBIDRef dBIDRef) {
        assert (!this.ids.contains(dBIDRef));
        if (this.content instanceof WritableDoubleDataStore) {
            ((WritableDoubleDataStore)this.content).delete(dBIDRef);
        }
    }

    @Override
    public StaticDBIDs getDBIDs() {
        return this.ids;
    }

    @Override
    public DBIDIter iterDBIDs() {
        return this.ids.iter();
    }

    @Override
    public int size() {
        return this.ids.size();
    }

    @Override
    public SimpleTypeInformation<Double> getDataTypeInformation() {
        return TypeUtil.DOUBLE;
    }

    @Override
    public String getLongName() {
        return this.name != null ? this.name : "Double";
    }

    @Override
    public String getShortName() {
        return this.shortname;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

