/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.relation;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.StaticDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.AbstractRelation;
import de.lmu.ifi.dbs.elki.database.relation.ModifiableRelation;
import de.lmu.ifi.dbs.elki.index.DynamicIndex;
import de.lmu.ifi.dbs.elki.index.Index;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;

public class MaterializedRelation<O>
extends AbstractRelation<O>
implements ModifiableRelation<O> {
    private static final Logging LOG = Logging.getLogger(MaterializedRelation.class);
    private final SimpleTypeInformation<O> type;
    private final DataStore<O> content;
    private final StaticDBIDs ids;
    private String name;
    private String shortname = "relation";

    public MaterializedRelation(SimpleTypeInformation<O> simpleTypeInformation, DBIDs dBIDs) {
        this(simpleTypeInformation, dBIDs, null);
    }

    public MaterializedRelation(SimpleTypeInformation<O> simpleTypeInformation, DBIDs dBIDs, String string) {
        this.type = simpleTypeInformation;
        this.ids = DBIDUtil.makeUnmodifiable(dBIDs);
        this.name = string;
        this.content = DataStoreUtil.makeStorage(dBIDs, 30, simpleTypeInformation.getRestrictionClass());
    }

    public MaterializedRelation(SimpleTypeInformation<O> simpleTypeInformation, DBIDs dBIDs, String string, DataStore<O> dataStore) {
        this.type = simpleTypeInformation;
        this.ids = DBIDUtil.makeUnmodifiable(dBIDs);
        this.name = string;
        this.content = dataStore;
    }

    public MaterializedRelation(String string, String string2, SimpleTypeInformation<O> simpleTypeInformation, DataStore<O> dataStore, DBIDs dBIDs) {
        this.type = simpleTypeInformation;
        this.ids = DBIDUtil.makeUnmodifiable(dBIDs);
        this.name = string;
        this.shortname = string2;
        this.content = dataStore;
    }

    @Override
    public O get(DBIDRef dBIDRef) {
        return this.content.get(dBIDRef);
    }

    @Override
    public void insert(DBIDRef dBIDRef, O o) {
        assert (this.ids.contains(dBIDRef)) : "Object not yet in DBIDs.";
        if (!(this.content instanceof WritableDataStore)) {
            throw new AbortException("Data is stored in a non-writable data store. Modifications are not possible.");
        }
        ((WritableDataStore)this.content).put(dBIDRef, o);
        Hierarchy.Iter<MaterializedRelation> iter = this.getHierarchy().iterDescendants(this);
        while (iter.valid()) {
            if (!(iter.get() instanceof DynamicIndex)) {
                if (iter.get() instanceof Index) {
                    throw new AbortException("A non-dynamic index was added to this database. Modifications are not allowed, unless this index is removed.");
                }
            } else {
                ((DynamicIndex)((Object)iter.get())).insert(dBIDRef);
            }
            iter.advance();
        }
    }

    @Override
    public void delete(DBIDRef dBIDRef) {
        assert (!this.ids.contains(dBIDRef)) : "Object still in DBIDs.";
        if (!(this.content instanceof WritableDataStore)) {
            throw new AbortException("Data is stored in a non-writable data store. Modifications are not possible.");
        }
        Hierarchy.Iter<MaterializedRelation> iter = this.getHierarchy().iterDescendants(this);
        while (iter.valid()) {
            if (!(iter.get() instanceof DynamicIndex)) {
                if (iter.get() instanceof Index) {
                    throw new AbortException("A non-dynamic index was added to this database. Modifications are not allowed, unless this index is removed.");
                }
            } else {
                ((DynamicIndex)((Object)iter.get())).delete(dBIDRef);
            }
            iter.advance();
        }
        ((WritableDataStore)this.content).delete(dBIDRef);
    }

    @Override
    public StaticDBIDs getDBIDs() {
        return this.ids;
    }

    @Override
    public DBIDIter iterDBIDs() {
        return this.ids.iter();
    }

    @Override
    public int size() {
        return this.ids.size();
    }

    @Override
    public SimpleTypeInformation<O> getDataTypeInformation() {
        return this.type;
    }

    @Override
    public String getLongName() {
        return this.name != null ? this.name : this.type.toString();
    }

    @Override
    public String getShortName() {
        return this.shortname;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

